/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Optional;
import java.util.TreeMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaOptionDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessorBuilder;
import org.apache.camel.processor.saga.SagaPropagation;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class SagaReifier
extends ProcessorReifier<SagaDefinition> {
    public SagaReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SagaDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        SagaCompletionMode completionMode;
        Optional<Endpoint> compensationEndpoint = Optional.ofNullable(((SagaDefinition)this.definition).getCompensation()).map(SendDefinition::getUri).map(this::resolveEndpoint);
        Optional<Endpoint> completionEndpoint = Optional.ofNullable(((SagaDefinition)this.definition).getCompletion()).map(SendDefinition::getUri).map(this::resolveEndpoint);
        TreeMap<String, Expression> optionsMap = new TreeMap<String, Expression>();
        if (((SagaDefinition)this.definition).getOptions() != null) {
            for (SagaOptionDefinition optionDef : ((SagaDefinition)this.definition).getOptions()) {
                String optionName = optionDef.getOptionName();
                ExpressionDefinition expr = optionDef.getExpression();
                optionsMap.put(optionName, expr);
            }
        }
        String timeout2 = ((SagaDefinition)this.definition).getTimeout() != null ? ((SagaDefinition)this.definition).getTimeout() : ((SagaDefinition)this.definition).getTimeoutInMilliseconds();
        CamelSagaStep step = new CamelSagaStep(compensationEndpoint, completionEndpoint, optionsMap, Optional.ofNullable(this.parseDuration(timeout2)));
        SagaPropagation propagation = this.parse(SagaPropagation.class, ((SagaDefinition)this.definition).getPropagation());
        if (propagation == null) {
            propagation = SagaPropagation.REQUIRED;
        }
        if ((completionMode = this.parse(SagaCompletionMode.class, ((SagaDefinition)this.definition).getCompletionMode())) == null) {
            completionMode = SagaCompletionMode.defaultCompletionMode();
        }
        Processor childProcessor = this.createChildProcessor(true);
        CamelSagaService camelSagaService = this.findSagaService();
        camelSagaService.registerStep(step);
        return new SagaProcessorBuilder().camelContext(this.camelContext).childProcessor(childProcessor).sagaService(camelSagaService).step(step).propagation(propagation).completionMode(completionMode).build();
    }

    protected CamelSagaService findSagaService() {
        CamelSagaService sagaService = ((SagaDefinition)this.definition).getSagaService();
        if (sagaService != null) {
            return sagaService;
        }
        String ref = this.parseString(((SagaDefinition)this.definition).getSagaServiceRef());
        if (ref != null) {
            return this.mandatoryLookup(ref, CamelSagaService.class);
        }
        sagaService = this.camelContext.hasService(CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        sagaService = this.findSingleByType(CamelSagaService.class);
        if (sagaService != null) {
            return sagaService;
        }
        throw new RuntimeCamelException("Cannot find a CamelSagaService");
    }
}

