/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.AggregationStrategyBiFunctionAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.reifier.ExpressionReifier;

public class SplitReifier
extends ExpressionReifier<SplitDefinition> {
    public SplitReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (SplitDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(true);
        ((SplitDefinition)this.definition).setAggregationStrategy(this.createAggregationStrategy());
        boolean isParallelProcessing = this.parseBoolean(((SplitDefinition)this.definition).getParallelProcessing(), false);
        boolean isStreaming = this.parseBoolean(((SplitDefinition)this.definition).getStreaming(), false);
        boolean isShareUnitOfWork = this.parseBoolean(((SplitDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isParallelAggregate = this.parseBoolean(((SplitDefinition)this.definition).getParallelAggregate(), false);
        boolean isStopOnAggregateException = this.parseBoolean(((SplitDefinition)this.definition).getStopOnAggregateException(), false);
        boolean isStopOnException = this.parseBoolean(((SplitDefinition)this.definition).getStopOnException(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("Split", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        long timeout2 = this.parseDuration(((SplitDefinition)this.definition).getTimeout(), 0L);
        if (timeout2 > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        String ref = this.parseString(((SplitDefinition)this.definition).getOnPrepareRef());
        if (ref != null) {
            ((SplitDefinition)this.definition).setOnPrepare(this.mandatoryLookup(ref, Processor.class));
        }
        Expression exp = this.createExpression(((SplitDefinition)this.definition).getExpression());
        String delimiter = this.parseString(((SplitDefinition)this.definition).getDelimiter());
        Splitter answer = delimiter != null ? new Splitter(this.camelContext, this.route, exp, childProcessor, ((SplitDefinition)this.definition).getAggregationStrategy(), isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout2, ((SplitDefinition)this.definition).getOnPrepare(), isShareUnitOfWork, isParallelAggregate, isStopOnAggregateException, delimiter) : new Splitter(this.camelContext, this.route, exp, childProcessor, ((SplitDefinition)this.definition).getAggregationStrategy(), isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout2, ((SplitDefinition)this.definition).getOnPrepare(), isShareUnitOfWork, isParallelAggregate, isStopOnAggregateException);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((SplitDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((SplitDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = this.lookup(((SplitDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy instanceof BiFunction) {
                AggregationStrategyBiFunctionAdapter adapter = new AggregationStrategyBiFunctionAdapter((BiFunction)aggStrategy);
                if (((SplitDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((SplitDefinition)this.definition).getStrategyMethodName());
                if (((SplitDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((SplitDefinition)this.definition).getStrategyRef());
            }
        }
        CamelContextAware.trySetCamelContext(strategy, this.camelContext);
        if (strategy != null && this.parseBoolean(((SplitDefinition)this.definition).getShareUnitOfWork(), false)) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

