/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;

public class ScheduledPollConsumerHealthCheck
implements HealthCheck {
    private final ScheduledPollConsumer consumer;
    private final String id;
    private final String sanitizedBaseUri;
    private final String sanitizedUri;

    public ScheduledPollConsumerHealthCheck(ScheduledPollConsumer consumer, String id) {
        this.consumer = consumer;
        this.id = id;
        this.sanitizedBaseUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointBaseUri());
        this.sanitizedUri = URISupport.sanitizeUri(consumer.getEndpoint().getEndpointUri());
    }

    @Override
    public HealthCheckConfiguration getConfiguration() {
        throw new UnsupportedOperationException("Configuration is not in use for this kind of health-check");
    }

    @Override
    public HealthCheck.Result call(Map<String, Object> options) {
        boolean healthy;
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on(this);
        builder.detail("endpoint.uri", this.sanitizedUri);
        builder.detail("failure.endpoint.uri", this.sanitizedUri);
        long ec = this.consumer.getErrorCounter();
        boolean first = this.consumer.isFirstPollDone();
        Throwable cause = this.consumer.getLastError();
        boolean bl = healthy = first && ec == 0L;
        if (healthy) {
            builder.up();
        } else {
            builder.down();
            builder.detail("failure.error.count", ec);
            String rid = this.consumer.getRouteId();
            if (ec > 0L) {
                String msg = "Consumer failed polling %s times route: %s (%s)";
                builder.message(String.format(msg, ec, rid, this.sanitizedBaseUri));
            } else {
                String msg = "Consumer has not yet polled route: %s (%s)";
                builder.message(String.format(msg, rid, this.sanitizedBaseUri));
            }
            builder.error(cause);
            if (this.consumer.getLastErrorDetails() != null) {
                builder.details(this.consumer.getLastErrorDetails());
            }
        }
        return builder.build();
    }

    @Override
    public String getGroup() {
        return "camel";
    }

    @Override
    public String getId() {
        return this.id;
    }
}

