/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.health;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.util.ObjectHelper;

public final class HealthCheckHelper {
    private HealthCheckHelper() {
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.ALL), check2 -> false, null);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, String exposureLevel) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.ALL), check2 -> false, exposureLevel);
    }

    public static Collection<HealthCheck.Result> invokeReadiness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.READINESS), check2 -> !check2.isReadiness(), null);
    }

    public static Collection<HealthCheck.Result> invokeReadiness(CamelContext camelContext, String exposureLevel) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.READINESS), check2 -> !check2.isReadiness(), exposureLevel);
    }

    public static Collection<HealthCheck.Result> invokeLiveness(CamelContext camelContext) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.LIVENESS), check2 -> !check2.isLiveness(), null);
    }

    public static Collection<HealthCheck.Result> invokeLiveness(CamelContext camelContext, String exposureLevel) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Map.of("check.kind", HealthCheck.Kind.LIVENESS), check2 -> !check2.isLiveness(), exposureLevel);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier) {
        return HealthCheckHelper.invoke(camelContext, optionsSupplier, check2 -> false, null);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Predicate<HealthCheck> filter) {
        return HealthCheckHelper.invoke(camelContext, check2 -> Collections.emptyMap(), filter, null);
    }

    public static Collection<HealthCheck.Result> invoke(CamelContext camelContext, Function<HealthCheck, Map<String, Object>> optionsSupplier, Predicate<HealthCheck> filter, String exposureLevel) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            Collection result = registry.stream().collect(Collectors.groupingBy(HealthCheckHelper::getGroup)).values().stream().flatMap(Collection::stream).filter(check2 -> !registry.isExcluded((HealthCheck)check2) && !filter.test((HealthCheck)check2)).sorted(Comparator.comparingInt(HealthCheck::getOrder)).distinct().map(check2 -> check2.call((Map)optionsSupplier.apply((HealthCheck)check2))).collect(Collectors.toList());
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            if (exposureLevel == null) {
                exposureLevel = registry.getExposureLevel();
            }
            if ("full".equals(exposureLevel)) {
                return result;
            }
            Collection downs = result.stream().filter(r -> r.getState().equals((Object)HealthCheck.State.DOWN)).collect(Collectors.toCollection(ArrayList::new));
            if (!downs.isEmpty()) {
                if ("oneline".equals(exposureLevel)) {
                    return Collections.singleton((HealthCheck.Result)downs.iterator().next());
                }
                return downs;
            }
            HealthCheck.Result up = (HealthCheck.Result)result.iterator().next();
            return Collections.singleton(up);
        }
        return Collections.emptyList();
    }

    public static Optional<HealthCheck.Result> invoke(CamelContext camelContext, String id, Map<String, Object> options) {
        HealthCheckRegistry registry = HealthCheckRegistry.get(camelContext);
        if (registry != null) {
            return registry.getCheck(id).map(check2 -> check2.call(options));
        }
        return Optional.empty();
    }

    public static HealthCheckRegistry getHealthCheckRegistry(CamelContext context) {
        return context.getExtension(HealthCheckRegistry.class);
    }

    public static HealthCheck getHealthCheck(CamelContext context, String id) {
        HealthCheck answer = null;
        HealthCheckRegistry hcr = context.getExtension(HealthCheckRegistry.class);
        if (hcr != null && hcr.isEnabled()) {
            HealthCheckResolver resolver;
            HealthCheck hc;
            Optional<HealthCheck> check2 = hcr.getCheck(id);
            if (check2.isEmpty() && (hc = (resolver = context.adapt(ExtendedCamelContext.class).getHealthCheckResolver()).resolveHealthCheck(id)) != null) {
                check2 = Optional.of(hc);
                hcr.register(hc);
            }
            if (check2.isPresent()) {
                answer = check2.get();
            }
        }
        return answer;
    }

    public static <T extends HealthCheck> T getHealthCheck(CamelContext context, String id, Class<T> type) {
        HealthCheck answer = HealthCheckHelper.getHealthCheck(context, id);
        if (answer != null) {
            return (T)((HealthCheck)type.cast(answer));
        }
        return null;
    }

    public static HealthCheckRepository getHealthCheckRepository(CamelContext context, String id) {
        HealthCheckRepository answer = null;
        HealthCheckRegistry hcr = context.getExtension(HealthCheckRegistry.class);
        if (hcr != null && hcr.isEnabled()) {
            HealthCheckResolver resolver;
            HealthCheckRepository hr;
            Optional<HealthCheckRepository> repo = hcr.getRepository(id);
            if (repo.isEmpty() && (hr = (resolver = context.adapt(ExtendedCamelContext.class).getHealthCheckResolver()).resolveHealthCheckRepository(id)) != null) {
                repo = Optional.of(hr);
                hcr.register(hr);
            }
            if (repo.isPresent()) {
                answer = repo.get();
            }
        }
        return answer;
    }

    public static <T extends HealthCheckRepository> T getHealthCheckRepository(CamelContext context, String id, Class<T> type) {
        HealthCheckRepository answer = HealthCheckHelper.getHealthCheckRepository(context, id);
        if (answer != null) {
            return (T)((HealthCheckRepository)type.cast(answer));
        }
        return null;
    }

    public static boolean isResultsUp(Collection<HealthCheck.Result> results, boolean readiness) {
        boolean up = readiness ? results.stream().allMatch(r -> r.getState().equals((Object)HealthCheck.State.UP)) : results.stream().noneMatch(r -> r.getState().equals((Object)HealthCheck.State.DOWN));
        return up;
    }

    private static String getGroup(HealthCheck check2) {
        return ObjectHelper.supplyIfEmpty(check2.getGroup(), () -> "");
    }

    public static boolean isReservedKey(String key) {
        if (key == null) {
            return false;
        }
        if ("check.id".equals(key)) {
            return true;
        }
        if ("check.group".equals(key)) {
            return true;
        }
        if ("check.kind".equals(key)) {
            return true;
        }
        if ("check.enabled".equals(key)) {
            return true;
        }
        if ("invocation.count".equals(key)) {
            return true;
        }
        if ("invocation.time".equals(key)) {
            return true;
        }
        if ("failure.count".equals(key)) {
            return true;
        }
        if ("failure.start.time".equals(key)) {
            return true;
        }
        if ("failure.time".equals(key)) {
            return true;
        }
        if ("failure.error.count".equals(key)) {
            return true;
        }
        if ("success.count".equals(key)) {
            return true;
        }
        if ("success.start.time".equals(key)) {
            return true;
        }
        return "success.time".equals(key);
    }
}

