/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.util.CamelURIParser;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Pair;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URIScanner;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class URISupport {
    public static final String RAW_TOKEN_PREFIX = "RAW";
    public static final char[] RAW_TOKEN_START = new char[]{'(', '{'};
    public static final char[] RAW_TOKEN_END = new char[]{')', '}'};
    private static final Pattern ALL_SECRETS = Pattern.compile("([?&][^=]*(?:" + SensitiveUtils.getSensitivePattern() + ")[^=]*)=(RAW(([{][^}]*[}])|([(][^)]*[)]))|[^&]*)", 2);
    private static final Pattern USERINFO_PASSWORD = Pattern.compile("(.*://.*?:)(.*)(@)");
    private static final Pattern PATH_USERINFO_PASSWORD = Pattern.compile("(.*?:)(.*)(@)");
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static String sanitizeUri(String uri) {
        String sanitized = uri;
        if (uri != null) {
            sanitized = ALL_SECRETS.matcher(sanitized).replaceAll("$1=xxxxxx");
            sanitized = USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static String sanitizePath(String path) {
        String sanitized = path;
        if (path != null) {
            sanitized = PATH_USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static String extractRemainderPath(URI u, boolean useRaw) {
        int idx;
        String path;
        String string = path = useRaw ? u.getRawSchemeSpecificPart() : u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) > -1) {
            path = path.substring(0, idx);
        }
        return path;
    }

    public static String extractQuery(String uri) {
        if (uri == null) {
            return null;
        }
        int pos = uri.indexOf(63);
        if (pos != -1) {
            return uri.substring(pos + 1);
        }
        return null;
    }

    public static String stripQuery(String uri) {
        int idx = uri.indexOf(63);
        if (idx > -1) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery(uri, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        return URISupport.parseQuery(uri, useRaw, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw, boolean lenient) throws URISyntaxException {
        if (uri == null || uri.isEmpty()) {
            return new LinkedHashMap<String, Object>(0);
        }
        if (!lenient && uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        URIScanner scanner = new URIScanner();
        return scanner.parseQuery(uri, useRaw);
    }

    public static List<Pair<Integer>> scanRaw(String str) {
        return URIScanner.scanRaw(str);
    }

    public static boolean isRaw(int index, List<Pair<Integer>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return false;
        }
        for (Pair<Integer> pair : pairs) {
            if (index < pair.getLeft()) {
                return false;
            }
            if (index > pair.getRight()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = URISupport.prepareQuery(uri);
        if (query == null) {
            return new LinkedHashMap<String, Object>(0);
        }
        return URISupport.parseQuery(query);
    }

    public static String prepareQuery(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.indexOf(63);
            if (idx < 0) {
                return null;
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else if (query.indexOf(63) == 0) {
            query = query.substring(1);
        }
        return query;
    }

    public static void resolveRawParameterValues(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    String str;
                    String raw;
                    Object obj = list.get(i);
                    if (obj == null || (raw = URIScanner.resolveRaw(str = obj.toString())) == null) continue;
                    String s = raw.replace("%25", "%");
                    list.set(i, s);
                }
                continue;
            }
            String str = entry.getValue().toString();
            String raw = URIScanner.resolveRaw(str);
            if (raw == null) continue;
            String s = raw.replace("%25", "%");
            entry.setValue(s);
        }
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        ObjectHelper.notNull(uri, "uri");
        Object s = uri.toString();
        String before = StringHelper.before((String)s, "?");
        if (before == null) {
            before = StringHelper.before((String)s, "#");
        }
        if (before != null) {
            s = before;
        }
        if (query != null) {
            s = (String)s + "?" + query;
        }
        if (!((String)s).contains("#") && uri.getFragment() != null) {
            s = (String)s + "#" + uri.getFragment();
        }
        return new URI((String)s);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value == null || prefix == null) {
            return value;
        }
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value == null || suffix == null) {
            return value;
        }
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public static String createQueryString(Map<String, Object> options) throws URISyntaxException {
        return URISupport.createQueryString(options.keySet(), options, true);
    }

    public static String createQueryString(Map<String, Object> options, boolean encode) throws URISyntaxException {
        return URISupport.createQueryString(options.keySet(), options, encode);
    }

    public static String createQueryString(Collection<String> sortedKeys, Map<String, Object> options, boolean encode) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (String o : sortedKeys) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String key = o;
                    Object value = options.get(key);
                    if (value instanceof List) {
                        List list = (List)value;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            URISupport.appendQueryStringParameter(key, s, rc, encode);
                            if (!it.hasNext()) continue;
                            rc.append("&");
                        }
                        continue;
                    }
                    String s = value != null ? value.toString() : null;
                    URISupport.appendQueryStringParameter(key, s, rc, encode);
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc, boolean encode) throws UnsupportedEncodingException {
        if (encode) {
            String encoded = URLEncoder.encode(key, CHARSET);
            rc.append(encoded);
        } else {
            rc.append(key);
        }
        if (value == null) {
            return;
        }
        rc.append("=");
        String raw = URIScanner.resolveRaw(value);
        if (raw != null) {
            String s = value.replace("%", "%25");
            rc.append(s);
        } else if (encode) {
            String encoded = URLEncoder.encode(value, CHARSET);
            rc.append(encoded);
        } else {
            rc.append(value);
        }
    }

    public static URI createRemainingURI(URI originalURI, Map<String, Object> params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static String appendParametersToURI(String originalURI, Map<String, Object> newParameters) throws URISyntaxException, UnsupportedEncodingException {
        URI uri = new URI(URISupport.normalizeUri(originalURI));
        Map<String, Object> parameters = URISupport.parseParameters(uri);
        parameters.putAll(newParameters);
        return URISupport.createRemainingURI(uri, parameters).toString();
    }

    public static String normalizeUri(String uri) throws URISyntaxException, UnsupportedEncodingException {
        String[] parts = CamelURIParser.fastParseUri(uri);
        if (parts != null) {
            if (parts == CamelURIParser.URI_ALREADY_NORMALIZED) {
                return uri;
            }
            return URISupport.doFastNormalizeUri(parts);
        }
        return URISupport.doComplexNormalizeUri(uri);
    }

    private static String doComplexNormalizeUri(String uri) throws URISyntaxException {
        String query;
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri, true));
        String scheme = u.getScheme();
        Object path = u.getSchemeSpecificPart();
        if (scheme == null || path == null) {
            return uri;
        }
        int start = ((String)path).startsWith("//") ? 2 : 0;
        int end = ((String)path).indexOf(63);
        if (start == 0 && end == 0 || start == 2 && end == 2) {
            path = "";
        } else {
            if (start != 0 && end == -1) {
                path = ((String)path).substring(start);
            } else if (end != -1) {
                path = ((String)path).substring(start, end);
            }
            path = scheme.startsWith("http") ? UnsafeUriCharactersEncoder.encodeHttpURI((String)path) : UnsafeUriCharactersEncoder.encode((String)path);
        }
        int idxPath = ((String)path).indexOf(47);
        if (StringHelper.countChar((String)path, '@', idxPath) > 1) {
            String userInfoPath = idxPath > 0 ? ((String)path).substring(0, idxPath) : path;
            int max = userInfoPath.lastIndexOf(64);
            String before = userInfoPath.substring(0, max);
            String after = ((String)path).substring(max);
            before = before.replace("@", "%40");
            path = before + after;
        }
        if ((query = URISupport.prepareQuery(u)) == null) {
            return URISupport.buildUri(scheme, (String)path, null);
        }
        Map<String, Object> parameters = URISupport.parseQuery(query, false, false);
        if (parameters.size() == 1) {
            query = URISupport.createQueryString(parameters);
            return URISupport.buildUri(scheme, (String)path, query);
        }
        ArrayList<String> keys2 = new ArrayList<String>(parameters.keySet());
        keys2.sort(null);
        query = URISupport.createQueryString(keys2, parameters, true);
        return URISupport.buildUri(scheme, (String)path, query);
    }

    private static String doFastNormalizeUri(String[] parts) throws URISyntaxException {
        String scheme = parts[0];
        String path = parts[1];
        String query = parts[2];
        if (query == null) {
            return URISupport.buildUri(scheme, path, null);
        }
        Map<String, Object> parameters = null;
        if (query.indexOf(38) != -1) {
            parameters = URISupport.parseQuery(query, false, false);
        }
        if (parameters == null || parameters.size() == 1) {
            return URISupport.buildUri(scheme, path, query);
        }
        boolean sort = false;
        String prev = null;
        for (String key : parameters.keySet()) {
            if (prev == null) {
                prev = key;
                continue;
            }
            int comp = key.compareTo(prev);
            if (comp < 0) {
                sort = true;
                break;
            }
            prev = key;
        }
        if (sort) {
            ArrayList<String> keys2 = new ArrayList<String>(parameters.keySet());
            keys2.sort(null);
            query = URISupport.createQueryString(keys2, parameters, true);
        }
        return URISupport.buildUri(scheme, path, query);
    }

    private static String buildUri(String scheme, String path, String query) {
        int len = scheme.length() + 3 + path.length();
        if (query != null) {
            StringBuilder sb = new StringBuilder(len += 1 + query.length());
            sb.append(scheme).append("://").append(path).append('?').append(query);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(scheme).append("://").append(path);
        return sb.toString();
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    public static String pathAndQueryOf(URI uri) {
        String query;
        String path = uri.getPath();
        Object pathAndQuery = path;
        if (ObjectHelper.isEmpty(path)) {
            pathAndQuery = "/";
        }
        if (ObjectHelper.isNotEmpty(query = uri.getQuery())) {
            pathAndQuery = (String)pathAndQuery + "?" + query;
        }
        return pathAndQuery;
    }

    public static String joinPaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder joined = new StringBuilder();
        boolean addedLast = false;
        for (int i = paths.length - 1; i >= 0; --i) {
            String path = paths[i];
            if (!ObjectHelper.isNotEmpty(path)) continue;
            if (addedLast) {
                path = URISupport.stripSuffix(path, "/");
            }
            addedLast = true;
            if (path.charAt(0) == '/') {
                joined.insert(0, path);
                continue;
            }
            if (i > 0) {
                joined.insert(0, '/').insert(1, path);
                continue;
            }
            joined.insert(0, path);
        }
        return joined.toString();
    }
}

