/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.Rejectable;
import org.apache.camel.util.concurrent.RejectableFutureTask;

public class RejectableThreadPoolExecutor
extends ThreadPoolExecutor {
    public RejectableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public RejectableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory2) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory2);
    }

    public RejectableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public RejectableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory2, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory2, handler);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable2, T value) {
        if (runnable2 instanceof Rejectable) {
            return new RejectableFutureTask<T>(runnable2, value);
        }
        return super.newTaskFor(runnable2, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof Rejectable) {
            return new RejectableFutureTask<T>(callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    public String toString() {
        if (this.getThreadFactory() instanceof CamelThreadFactory) {
            String name = ((CamelThreadFactory)this.getThreadFactory()).getName();
            return super.toString() + "[" + name + "]";
        }
        return super.toString();
    }
}

