/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.collection;

import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.CollectionOperation;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.RemoveOptions;

public class RemoveCollectionOperation
extends AbstractNitriteOperation
implements CollectionOperation {
    private Filter filter;
    private RemoveOptions removeOptions;

    public RemoveCollectionOperation(Filter filter) {
        this.filter = filter;
    }

    public RemoveCollectionOperation(Filter filter, RemoveOptions removeOptions) {
        this.filter = filter;
        this.removeOptions = removeOptions;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        NitriteCollection collection = (NitriteCollection)endpoint.getNitriteCollection();
        if (this.filter != null && this.removeOptions != null) {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", collection.remove(this.filter, this.removeOptions));
        } else {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", collection.remove(this.filter));
        }
    }
}

