/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.collection;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.AbstractPayloadAwareOperation;
import org.apache.camel.component.nitrite.operation.CollectionOperation;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.UpdateOptions;

public class UpdateCollectionOperation
extends AbstractPayloadAwareOperation
implements CollectionOperation {
    private Filter filter;
    private UpdateOptions updateOptions;

    public UpdateCollectionOperation(Filter filter) {
        this.filter = filter;
    }

    public UpdateCollectionOperation(Filter filter, UpdateOptions updateOptions) {
        this.filter = filter;
        this.updateOptions = updateOptions;
    }

    public UpdateCollectionOperation(Filter filter, Document document) {
        super(document);
        this.filter = filter;
    }

    public UpdateCollectionOperation(Filter filter, UpdateOptions updateOptions, Document document) {
        super(document);
        this.filter = filter;
        this.updateOptions = updateOptions;
    }

    public UpdateCollectionOperation(Filter filter, Expression documentExpression) {
        super(documentExpression);
        this.filter = filter;
    }

    public UpdateCollectionOperation(Filter filter, UpdateOptions updateOptions, Expression documentExpression) {
        super(documentExpression);
        this.filter = filter;
        this.updateOptions = updateOptions;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        NitriteCollection collection = (NitriteCollection)endpoint.getNitriteCollection();
        Document payload = (Document)this.getPayload(exchange, endpoint);
        if (this.filter != null && this.updateOptions != null) {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", collection.update(this.filter, payload, this.updateOptions));
        } else {
            exchange.getMessage().setHeader("CamelNitriteWriteResult", collection.update(this.filter, payload));
        }
    }
}

