/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.repository;

import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.RepositoryOperation;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;

public class FindRepositoryOperation
extends AbstractNitriteOperation
implements RepositoryOperation {
    private ObjectFilter objectFilter;
    private FindOptions findOptions;

    public FindRepositoryOperation() {
    }

    public FindRepositoryOperation(ObjectFilter objectFilter) {
        this.objectFilter = objectFilter;
    }

    public FindRepositoryOperation(ObjectFilter objectFilter, FindOptions findOptions) {
        this.objectFilter = objectFilter;
        this.findOptions = findOptions;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        ObjectRepository repository = (ObjectRepository)endpoint.getNitriteCollection();
        if (this.objectFilter != null && this.findOptions != null) {
            exchange.getMessage().setBody(repository.find(this.objectFilter, this.findOptions));
        } else if (this.objectFilter != null) {
            exchange.getMessage().setBody(repository.find(this.objectFilter));
        } else {
            exchange.getMessage().setBody(repository.find());
        }
    }
}

