/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContextReloadStrategy
extends ServiceSupport
implements ContextReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultContextReloadStrategy.class);
    private CamelContext camelContext;
    private int succeeded;
    private int failed;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedOperation(description="Trigger on-demand reloading")
    public void onReload() {
        this.onReload("JMX Management");
    }

    @Override
    public void onReload(Object source2) {
        LOG.info("Reloading CamelContext ({}) triggered by: {}", (Object)this.camelContext.getName(), source2);
        try {
            EventHelper.notifyContextReloading(this.getCamelContext(), source2);
            this.reloadProperties(source2);
            this.reloadRoutes(source2);
            this.incSucceededCounter();
            EventHelper.notifyContextReloaded(this.getCamelContext(), source2);
        }
        catch (Exception e) {
            this.incFailedCounter();
            LOG.warn("Error reloading CamelContext (" + this.camelContext.getName() + ") due to: " + e.getMessage(), (Throwable)e);
            EventHelper.notifyContextReloadFailure(this.getCamelContext(), source2, e);
        }
    }

    protected void reloadRoutes(Object source2) throws Exception {
        this.getCamelContext().getRouteController().reloadAllRoutes();
    }

    protected void reloadProperties(Object source2) throws Exception {
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        for (PropertiesSource ps : pc.getPropertiesSources()) {
            ServiceHelper.stopAndShutdownService(ps);
            ServiceHelper.startService((Object)ps);
        }
    }

    @Override
    @ManagedAttribute(description="Number of reloads succeeded")
    public int getReloadCounter() {
        return this.succeeded;
    }

    @Override
    @ManagedAttribute(description="Number of reloads failed")
    public int getFailedCounter() {
        return this.failed;
    }

    public void setSucceeded(int succeeded) {
        this.succeeded = succeeded;
    }

    public void setFailed(int failed) {
        this.failed = failed;
    }

    @Override
    @ManagedOperation(description="Reset counters")
    public void resetCounters() {
        this.succeeded = 0;
        this.failed = 0;
    }

    protected void incSucceededCounter() {
        ++this.succeeded;
    }

    protected void incFailedCounter() {
        ++this.failed;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

