/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;

public final class ApiMethodImpl
implements ApiMethod {
    private final String name;
    private final Class<?> resultType;
    private final List<String> argNames;
    private final List<Class<?>> argTypes;
    private final Method method;

    public ApiMethodImpl(Class<?> proxyType, Class<?> resultType, String name, ApiMethodArg ... args2) throws IllegalArgumentException {
        this.name = name;
        this.resultType = resultType;
        ArrayList<String> tmpArgNames = new ArrayList<String>(args2.length);
        ArrayList tmpArgTypes = new ArrayList(args2.length);
        for (ApiMethodArg arg : args2) {
            tmpArgTypes.add(arg.getType());
            tmpArgNames.add(arg.getName());
        }
        this.argNames = Collections.unmodifiableList(tmpArgNames);
        this.argTypes = Collections.unmodifiableList(tmpArgTypes);
        try {
            this.method = proxyType.getMethod(name, this.argTypes.toArray(new Class[args2.length]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Missing method %s %s", name, this.argTypes.toString().replace('[', '(').replace(']', ')')), e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getResultType() {
        return this.resultType;
    }

    @Override
    public List<String> getArgNames() {
        return this.argNames;
    }

    @Override
    public List<Class<?>> getArgTypes() {
        return this.argTypes;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("name=").append(this.name).append(", resultType=").append(this.resultType).append(", argNames=").append(this.argNames).append(", argTypes=").append(this.argTypes).append("}");
        return builder.toString();
    }
}

