/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.io.IOException;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.dizitart.no2.sync.data.UserAgent;
import org.dizitart.no2.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGateClient {
    private static final Logger log = LoggerFactory.getLogger(DataGateClient.class);
    private String serverBaseUrl;
    private String username;
    private String password;
    private Proxy proxy;
    private boolean trustAllCerts;
    private long readTimeout = 0L;
    private long connectTimeout = 0L;
    private UserAgent userAgent;

    public DataGateClient(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public DataGateClient withAuth(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public DataGateClient withProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public DataGateClient trustAllCerts() {
        this.trustAllCerts = true;
        return this;
    }

    public DataGateClient readTimeout(long milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public DataGateClient connectTimeout(long milliseconds) {
        this.connectTimeout = milliseconds;
        return this;
    }

    public DataGateClient withUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    protected String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    protected OkHttpClient getHttpClient() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (!StringUtils.isNullOrEmpty(this.username)) {
            clientBuilder.addInterceptor(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request();
                    Request newRequest = request.newBuilder().addHeader("Authorization", Credentials.basic(DataGateClient.this.username, DataGateClient.this.password)).build();
                    return chain.proceed(newRequest);
                }
            });
        }
        if (this.userAgent != null) {
            clientBuilder.addInterceptor(new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request();
                    Request newRequest = request.newBuilder().addHeader("userAgent", DataGateClient.this.userAgent.toString()).build();
                    return chain.proceed(newRequest);
                }
            });
        }
        if (this.proxy != null) {
            clientBuilder.proxy(this.proxy);
        }
        if (this.trustAllCerts) {
            try {
                TrustManager[] trustManagers = new X509TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustManagers, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                clientBuilder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]);
            }
            catch (Exception e) {
                log.error("Error while bypassing certificate chains", (Throwable)e);
            }
            clientBuilder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        if (this.readTimeout != 0L) {
            clientBuilder.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.connectTimeout != 0L) {
            clientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        return clientBuilder.build();
    }
}

