/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.util;

import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorAwareThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(ErrorAwareThreadFactory.class);

    public abstract Thread createThread(Runnable var1);

    @Override
    public Thread newThread(Runnable r) {
        Thread thread2 = this.createThread(r);
        if (thread2.getUncaughtExceptionHandler() == null) {
            thread2.setUncaughtExceptionHandler(this.getUncaughtErrorHandler());
        }
        return thread2;
    }

    protected Thread.UncaughtExceptionHandler getUncaughtErrorHandler() {
        return new UncaughtErrorHandler();
    }

    private class UncaughtErrorHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtErrorHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Unhandled error in " + t.getName(), e);
        }
    }
}

