/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.frames;

import com.github.brainlag.nsq.frames.NSQFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class MessageFrame
extends NSQFrame {
    private long timestamp;
    private int attempts;
    private byte[] messageId = new byte[16];
    private byte[] messageBody;

    @Override
    public void setData(byte[] bytes) {
        super.setData(bytes);
        ByteBuf buf = Unpooled.wrappedBuffer(bytes);
        this.timestamp = buf.readLong();
        this.attempts = buf.readShort();
        buf.readBytes(this.messageId);
        ByteBuf messageBodyBuf = buf.readBytes(buf.readableBytes());
        if (messageBodyBuf.hasArray()) {
            this.messageBody = messageBodyBuf.array();
        } else {
            byte[] array = new byte[messageBodyBuf.readableBytes()];
            messageBodyBuf.readBytes(array);
            this.messageBody = array;
        }
        buf.release();
        messageBodyBuf.release();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public byte[] getMessageId() {
        return this.messageId;
    }

    public byte[] getMessageBody() {
        return this.messageBody;
    }
}

