/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.netty;

import com.github.brainlag.nsq.frames.NSQFrame;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class NSQDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private int size;
    private NSQFrame frame;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.size = in.readInt();
        int id = in.readInt();
        this.frame = NSQFrame.instance(id);
        if (this.frame == null) {
            throw new Exception("Bad frame id from server (" + id + ").  disconnect!");
        }
        this.frame.setSize(this.size);
        ByteBuf bytes = in.readBytes(this.frame.getSize() - 4);
        if (bytes.hasArray()) {
            this.frame.setData(bytes.array());
        } else {
            byte[] array = new byte[bytes.readableBytes()];
            bytes.readBytes(array);
            this.frame.setData(array);
        }
        out.add(this.frame);
        bytes.release();
    }
}

