/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.netty;

import com.github.brainlag.nsq.Connection;
import com.github.brainlag.nsq.frames.NSQFrame;
import com.github.brainlag.nsq.frames.ResponseFrame;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.compression.SnappyFramedDecoder;
import io.netty.handler.codec.compression.SnappyFramedEncoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;

public class NSQFeatureDetectionHandler
extends SimpleChannelInboundHandler<NSQFrame> {
    private boolean ssl;
    private boolean compression;
    private boolean snappy;
    private boolean deflate;
    private boolean finished;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, NSQFrame msg) throws Exception {
        LogManager.getLogger(this).info("IdentifyResponse: " + new String(msg.getData()));
        boolean reinstallDefaultDecoder = true;
        if (msg instanceof ResponseFrame) {
            ResponseFrame response = (ResponseFrame)msg;
            ChannelPipeline pipeline = ctx.channel().pipeline();
            Connection con = ctx.channel().attr(Connection.STATE).get();
            this.parseIdentify(response.getMessage());
            if (response.getMessage().equals("OK")) {
                if (this.finished) {
                    return;
                }
                if (this.snappy) {
                    reinstallDefaultDecoder = this.installSnappyDecoder(pipeline);
                }
                if (this.deflate) {
                    reinstallDefaultDecoder = this.installDeflateDecoder(pipeline, con);
                }
                this.eject(reinstallDefaultDecoder, pipeline);
                if (this.ssl) {
                    ((SslHandler)pipeline.get("SSLHandler")).setSingleDecode(false);
                }
                return;
            }
            if (this.ssl) {
                LogManager.getLogger(this).info("Adding SSL to pipline");
                SSLEngine sslEngine = con.getConfig().getSslContext().newEngine(ctx.channel().alloc());
                sslEngine.setUseClientMode(true);
                SslHandler sslHandler = new SslHandler(sslEngine, false);
                sslHandler.setSingleDecode(true);
                pipeline.addBefore("LengthFieldBasedFrameDecoder", "SSLHandler", sslHandler);
                if (this.snappy) {
                    pipeline.addBefore("NSQEncoder", "SnappyEncoder", new SnappyFramedEncoder());
                }
                if (this.deflate) {
                    pipeline.addBefore("NSQEncoder", "DeflateEncoder", ZlibCodecFactory.newZlibEncoder(ZlibWrapper.NONE, con.getConfig().getDeflateLevel()));
                }
            }
            if (!this.ssl && this.snappy) {
                pipeline.addBefore("NSQEncoder", "SnappyEncoder", new SnappyFramedEncoder());
                reinstallDefaultDecoder = this.installSnappyDecoder(pipeline);
            }
            if (!this.ssl && this.deflate) {
                pipeline.addBefore("NSQEncoder", "DeflateEncoder", ZlibCodecFactory.newZlibEncoder(ZlibWrapper.NONE, con.getConfig().getDeflateLevel()));
                reinstallDefaultDecoder = this.installDeflateDecoder(pipeline, con);
            }
            if (response.getMessage().contains("version") && this.finished) {
                this.eject(reinstallDefaultDecoder, pipeline);
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void eject(boolean reinstallDefaultDecoder, ChannelPipeline pipeline) {
        pipeline.remove(this);
        if (reinstallDefaultDecoder) {
            LogManager.getLogger(this).info("reinstall LengthFieldBasedFrameDecoder");
            pipeline.replace("LengthFieldBasedFrameDecoder", "LengthFieldBasedFrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4));
        }
    }

    private boolean installDeflateDecoder(ChannelPipeline pipeline, Connection con) {
        this.finished = true;
        LogManager.getLogger(this).info("Adding deflate to pipline");
        pipeline.replace("LengthFieldBasedFrameDecoder", "DeflateDecoder", (ChannelHandler)ZlibCodecFactory.newZlibDecoder(ZlibWrapper.NONE));
        return false;
    }

    private boolean installSnappyDecoder(ChannelPipeline pipeline) {
        this.finished = true;
        LogManager.getLogger(this).info("Adding snappy to pipline");
        pipeline.replace("LengthFieldBasedFrameDecoder", "SnappyDecoder", (ChannelHandler)new SnappyFramedDecoder());
        return false;
    }

    private void parseIdentify(String message) {
        if (message.equals("OK")) {
            return;
        }
        if (message.contains("\"tls_v1\":true")) {
            this.ssl = true;
        }
        if (message.contains("\"snappy\":true")) {
            this.snappy = true;
            this.compression = true;
        }
        if (message.contains("\"deflate\":true")) {
            this.deflate = true;
            this.compression = true;
        }
        if (!this.ssl && !this.compression) {
            this.finished = true;
        }
    }
}

