/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.pool;

import com.github.brainlag.nsq.Connection;
import com.github.brainlag.nsq.NSQCommand;
import com.github.brainlag.nsq.NSQConfig;
import com.github.brainlag.nsq.ServerAddress;
import io.netty.channel.ChannelFuture;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ConnectionPoolFactory
extends BaseKeyedPooledObjectFactory<ServerAddress, Connection> {
    private NSQConfig config;

    public ConnectionPoolFactory(NSQConfig config) {
        this.config = config;
    }

    @Override
    public Connection create(ServerAddress serverAddress) throws Exception {
        return new Connection(serverAddress, this.config);
    }

    @Override
    public PooledObject<Connection> wrap(Connection con) {
        return new DefaultPooledObject<Connection>(con);
    }

    @Override
    public boolean validateObject(ServerAddress key, PooledObject<Connection> p) {
        ChannelFuture command = p.getObject().command(NSQCommand.nop());
        return command.awaitUninterruptibly().isSuccess();
    }

    @Override
    public void destroyObject(ServerAddress key, PooledObject<Connection> p) throws Exception {
        p.getObject().close();
    }
}

