/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nsq;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NsqEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    @Override
    public boolean isEnabled(String scheme) {
        return "nsq".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "topic", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(18);
        props.add("customNSQLookup");
        props.add("requeueInterval");
        props.add("lookupInterval");
        props.add("autoFinish");
        props.add("poolSize");
        props.add("channel");
        props.add("exchangePattern");
        props.add("sslContextParameters");
        props.add("userAgent");
        props.add("lookupServerPort");
        props.add("secure");
        props.add("lazyStartProducer");
        props.add("servers");
        props.add("bridgeErrorHandler");
        props.add("port");
        props.add("topic");
        props.add("exceptionHandler");
        props.add("messageTimeout");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

