/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.model;

import java.io.IOException;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class OAIPMHResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OAIPMHResponse.class);
    private String rawResponse;
    private Document xmlResponse;

    public OAIPMHResponse(String rawResponse) throws ParserConfigurationException, SAXException, IOException {
        this.rawResponse = rawResponse;
        this.parse();
    }

    private void parse() throws ParserConfigurationException, SAXException, IOException {
        this.xmlResponse = Jsoup.parse(this.rawResponse, "", Parser.xmlParser());
    }

    public Optional<String> getResumptionToken() {
        Optional<String> vl = Optional.empty();
        Elements elementsByTag = this.xmlResponse.getElementsByTag("resumptionToken");
        if (!elementsByTag.isEmpty()) {
            if (elementsByTag.size() > 1) {
                LOG.warn("Multiple 'resumptionToken' tags detected, taking the first one.");
            }
            Element get = (Element)elementsByTag.get(0);
            vl = Optional.of(get.text().trim());
        }
        return vl;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(String rawResponse) {
        this.rawResponse = rawResponse;
    }

    public Document getXmlResponse() {
        return this.xmlResponse;
    }

    public void setXmlResponse(Document xmlResponse) {
        this.xmlResponse = xmlResponse;
    }
}

