/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIPMHHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(OAIPMHHttpClient.class);
    private boolean ignoreSSLWarnings;

    public String doRequest(URI baseURI, String verb, String set, String from, String until, String metadataPrefix, String token, String identifier) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpclient = this.getCloseableHttpClient();){
            URIBuilder builder = new URIBuilder();
            builder.setScheme(baseURI.getScheme()).setHost(baseURI.getHost()).setPort(baseURI.getPort()).setPath(baseURI.getPath()).addParameter("verb", verb).addParameters(URLEncodedUtils.parse(baseURI, Charset.defaultCharset()));
            if (identifier != null) {
                builder.addParameter("identifier", identifier);
            }
            if (token != null) {
                builder.addParameter("resumptionToken", token);
            } else {
                if (metadataPrefix != null) {
                    builder.addParameter("metadataPrefix", metadataPrefix);
                }
                if (set != null) {
                    builder.addParameter("set", set);
                }
                if (from != null) {
                    builder.addParameter("from", from);
                }
                if (until != null) {
                    builder.addParameter("until", until);
                }
            }
            HttpGet httpget = new HttpGet(builder.build());
            RequestLine requestLine = httpget.getRequestLine();
            LOG.info("Executing request: {} ", (Object)requestLine);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                @Override
                public String handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            throw new IOException("No response received");
                        }
                        return EntityUtils.toString(entity, StandardCharsets.UTF_8);
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String responseBody = httpclient.execute((HttpUriRequest)httpget, responseHandler);
            LOG.debug("Response received: {}", (Object)responseBody);
            String string = responseBody;
            return string;
        }
    }

    protected CloseableHttpClient getCloseableHttpClient() throws IOException {
        if (this.isIgnoreSSLWarnings()) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
                return HttpClients.custom().setSSLSocketFactory(sslsf).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new IOException("The HTTP Client could not be started", ex);
            }
        }
        return HttpClients.createDefault();
    }

    public boolean isIgnoreSSLWarnings() {
        return this.ignoreSSLWarnings;
    }

    public void setIgnoreSSLWarnings(boolean ignoreSSLWarnings) {
        this.ignoreSSLWarnings = ignoreSSLWarnings;
    }
}

