/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ognl;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.language.ognl.CamelClassResolver;
import org.apache.camel.language.ognl.RootObject;
import org.apache.camel.support.ExpressionSupport;

public class OgnlExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private Object expression;

    public OgnlExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        try {
            this.expression = Ognl.parseExpression(expressionString);
        }
        catch (OgnlException e) {
            throw new ExpressionIllegalSyntaxException(expressionString, e);
        }
    }

    public static OgnlExpression ognl(String expression) {
        return new OgnlExpression(expression, Object.class);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        OgnlContext oglContext = new OgnlContext();
        oglContext.setClassResolver(new CamelClassResolver(exchange.getContext().getClassResolver()));
        try {
            Object value = Ognl.getValue(this.expression, (Map)oglContext, (Object)new RootObject(exchange));
            return exchange.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException(this, exchange, e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "OGNL[" + this.expressionString + "]";
    }
}

