/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.batch;

import java.util.Map;
import org.apache.camel.component.olingo2.api.batch.Olingo2BatchRequest;

public class Olingo2BatchQueryRequest
extends Olingo2BatchRequest {
    private Map<String, String> queryParams;

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public static Olingo2BatchQueryRequestBuilder resourcePath(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath");
        }
        return new Olingo2BatchQueryRequestBuilder().resourcePath(resourcePath);
    }

    @Override
    public String toString() {
        return "Batch Query Request{ " + this.resourcePath + ", headers=" + this.headers + ", queryParams=" + this.queryParams + '}';
    }

    public static class Olingo2BatchQueryRequestBuilder {
        private Olingo2BatchQueryRequest request = new Olingo2BatchQueryRequest();

        public Olingo2BatchQueryRequest build() {
            if (this.request.resourcePath == null) {
                throw new IllegalArgumentException("Null resourcePath");
            }
            return this.request;
        }

        public Olingo2BatchQueryRequestBuilder resourcePath(String resourcePath) {
            this.request.resourcePath = resourcePath;
            return this;
        }

        public Olingo2BatchQueryRequestBuilder headers(Map<String, String> headers) {
            this.request.headers = headers;
            return this;
        }

        public Olingo2BatchQueryRequestBuilder queryParams(Map<String, String> queryParams) {
            return this;
        }
    }
}

