/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.ep;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.client.batch.BatchPart;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;
import org.apache.olingo.odata2.api.servicedocument.ServiceDocument;

public final class EntityProvider {
    private static EntityProviderInterface createEntityProvider() {
        return RuntimeDelegate.createEntityProvider();
    }

    public static ODataResponse writeErrorDocument(ODataErrorContext context) {
        return EntityProvider.createEntityProvider().writeErrorDocument(context);
    }

    public static ODataResponse writeMetadata(List<Schema> schemas, Map<String, String> predefinedNamespaces) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeMetadata(schemas, predefinedNamespaces);
    }

    public static ODataResponse writeServiceDocument(String contentType, Edm edm, String serviceRoot) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeServiceDocument(contentType, edm, serviceRoot);
    }

    public static ODataResponse writePropertyValue(EdmProperty edmProperty, Object value) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writePropertyValue(edmProperty, value);
    }

    public static ODataResponse writeText(String value) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeText(value);
    }

    public static ODataResponse writeBinary(String mimeType, byte[] data) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeBinary(mimeType, data);
    }

    public static ODataResponse writeFeed(String contentType, EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeFeed(contentType, entitySet, data, properties);
    }

    public static ODataResponse writeEntry(String contentType, EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeEntry(contentType, entitySet, data, properties);
    }

    public static ODataResponse writeProperty(String contentType, EdmProperty edmProperty, Object value) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeProperty(contentType, edmProperty, value);
    }

    public static ODataResponse writeLink(String contentType, EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeLink(contentType, entitySet, data, properties);
    }

    public static ODataResponse writeLinks(String contentType, EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeLinks(contentType, entitySet, data, properties);
    }

    public static ODataResponse writeFunctionImport(String contentType, EdmFunctionImport functionImport, Object data, EntityProviderWriteProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().writeFunctionImport(contentType, functionImport, data, properties);
    }

    public static ODataFeed readFeed(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readFeed(contentType, entitySet, content, properties);
    }

    public static ODataDeltaFeed readDeltaFeed(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readDeltaFeed(contentType, entitySet, content, properties);
    }

    public static ODataEntry readEntry(String contentType, EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readEntry(contentType, entitySet, content, properties);
    }

    public static Map<String, Object> readProperty(String contentType, EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readProperty(contentType, edmProperty, content, properties);
    }

    public static Object readPropertyValue(EdmProperty edmProperty, InputStream content) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readPropertyValue(edmProperty, content, null);
    }

    public static Object readPropertyValue(EdmProperty edmProperty, InputStream content, Class<?> typeMapping) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readPropertyValue(edmProperty, content, typeMapping);
    }

    public static String readLink(String contentType, EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readLink(contentType, entitySet, content);
    }

    public static List<String> readLinks(String contentType, EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readLinks(contentType, entitySet, content);
    }

    public static byte[] readBinary(InputStream content) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readBinary(content);
    }

    public static Edm readMetadata(InputStream metadataXml, boolean validate) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readMetadata(metadataXml, validate);
    }

    public static ODataErrorContext readErrorDocument(InputStream errorDocument, String contentType) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readErrorDocument(errorDocument, contentType);
    }

    public static ServiceDocument readServiceDocument(InputStream serviceDocument, String contentType) throws EntityProviderException {
        return EntityProvider.createEntityProvider().readServiceDocument(serviceDocument, contentType);
    }

    public static List<BatchRequestPart> parseBatchRequest(String contentType, InputStream content, EntityProviderBatchProperties properties) throws BatchException {
        return EntityProvider.createEntityProvider().parseBatchRequest(contentType, content, properties);
    }

    public static ODataResponse writeBatchResponse(List<BatchResponsePart> batchResponseParts) throws BatchException {
        return EntityProvider.createEntityProvider().writeBatchResponse(batchResponseParts);
    }

    public static InputStream writeBatchRequest(List<BatchPart> batchParts, String boundary) {
        return EntityProvider.createEntityProvider().writeBatchRequest(batchParts, boundary);
    }

    public static List<BatchSingleResponse> parseBatchResponse(InputStream content, String contentType) throws BatchException {
        return EntityProvider.createEntityProvider().parseBatchResponse(contentType, content);
    }

    public static interface EntityProviderInterface {
        public ODataResponse writeMetadata(List<Schema> var1, Map<String, String> var2) throws EntityProviderException;

        public ODataResponse writeServiceDocument(String var1, Edm var2, String var3) throws EntityProviderException;

        public ODataResponse writePropertyValue(EdmProperty var1, Object var2) throws EntityProviderException;

        public ODataResponse writeText(String var1) throws EntityProviderException;

        public ODataResponse writeBinary(String var1, byte[] var2) throws EntityProviderException;

        public ODataResponse writeFeed(String var1, EdmEntitySet var2, List<Map<String, Object>> var3, EntityProviderWriteProperties var4) throws EntityProviderException;

        public ODataResponse writeEntry(String var1, EdmEntitySet var2, Map<String, Object> var3, EntityProviderWriteProperties var4) throws EntityProviderException;

        public ODataResponse writeProperty(String var1, EdmProperty var2, Object var3) throws EntityProviderException;

        public ODataResponse writeLink(String var1, EdmEntitySet var2, Map<String, Object> var3, EntityProviderWriteProperties var4) throws EntityProviderException;

        public ODataResponse writeLinks(String var1, EdmEntitySet var2, List<Map<String, Object>> var3, EntityProviderWriteProperties var4) throws EntityProviderException;

        public ODataResponse writeFunctionImport(String var1, EdmFunctionImport var2, Object var3, EntityProviderWriteProperties var4) throws EntityProviderException;

        public ODataFeed readFeed(String var1, EdmEntitySet var2, InputStream var3, EntityProviderReadProperties var4) throws EntityProviderException;

        public ODataDeltaFeed readDeltaFeed(String var1, EdmEntitySet var2, InputStream var3, EntityProviderReadProperties var4) throws EntityProviderException;

        public ODataEntry readEntry(String var1, EdmEntitySet var2, InputStream var3, EntityProviderReadProperties var4) throws EntityProviderException;

        public Map<String, Object> readProperty(String var1, EdmProperty var2, InputStream var3, EntityProviderReadProperties var4) throws EntityProviderException;

        public Object readPropertyValue(EdmProperty var1, InputStream var2, Class<?> var3) throws EntityProviderException;

        public String readLink(String var1, EdmEntitySet var2, InputStream var3) throws EntityProviderException;

        public List<String> readLinks(String var1, EdmEntitySet var2, InputStream var3) throws EntityProviderException;

        public Edm readMetadata(InputStream var1, boolean var2) throws EntityProviderException;

        public byte[] readBinary(InputStream var1) throws EntityProviderException;

        public ODataResponse writeErrorDocument(ODataErrorContext var1);

        public ServiceDocument readServiceDocument(InputStream var1, String var2) throws EntityProviderException;

        public List<BatchRequestPart> parseBatchRequest(String var1, InputStream var2, EntityProviderBatchProperties var3) throws BatchException;

        public ODataResponse writeBatchResponse(List<BatchResponsePart> var1) throws BatchException;

        public InputStream writeBatchRequest(List<BatchPart> var1, String var2);

        public List<BatchSingleResponse> parseBatchResponse(String var1, InputStream var2) throws BatchException;

        public ODataErrorContext readErrorDocument(InputStream var1, String var2) throws EntityProviderException;
    }
}

