/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.component.olingo2.api.impl.UriType;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;

public class UriInfoWithType
implements UriInfo {
    private final UriInfo uriInfo;
    private final UriType uriType;

    public UriInfoWithType(UriInfo uriInfo, String resourcePath) throws ODataApplicationException, EdmException {
        UriType uriType;
        block24: {
            block25: {
                boolean isCount;
                boolean isLinks;
                List<NavigationSegment> segments;
                block26: {
                    block23: {
                        this.uriInfo = uriInfo;
                        segments = uriInfo.getNavigationSegments();
                        isLinks = uriInfo.isLinks();
                        if (!segments.isEmpty() || uriInfo.getTargetType() != null) break block23;
                        uriType = UriType.URI0;
                        if (resourcePath.endsWith("$metadata")) {
                            uriType = UriType.URI8;
                        } else if (resourcePath.endsWith("$batch")) {
                            uriType = UriType.URI9;
                        }
                        break block24;
                    }
                    EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
                    if (targetEntitySet == null) break block25;
                    isCount = uriInfo.isCount();
                    List<KeyPredicate> keyPredicates = uriInfo.getKeyPredicates();
                    if (!keyPredicates.isEmpty()) break block26;
                    uriType = !isCount ? UriType.URI1 : UriType.URI15;
                    break block24;
                }
                uriType = UriType.URI2;
                if (isCount) {
                    uriType = UriType.URI16;
                } else if (uriInfo.isValue()) {
                    uriType = UriType.URI17;
                }
                EdmTypeKind targetKind = uriInfo.getTargetType().getKind();
                switch (targetKind) {
                    case SIMPLE: {
                        if (segments.isEmpty()) {
                            uriType = UriType.URI5;
                            break;
                        }
                        uriType = UriType.URI4;
                        break;
                    }
                    case COMPLEX: {
                        uriType = UriType.URI3;
                        break;
                    }
                    case ENTITY: {
                        List<EdmProperty> propertyPath = uriInfo.getPropertyPath();
                        if (!segments.isEmpty() || !propertyPath.isEmpty()) {
                            boolean many = false;
                            if (!propertyPath.isEmpty()) {
                                EdmProperty lastProperty = propertyPath.get(propertyPath.size() - 1);
                                many = lastProperty.getMultiplicity() == EdmMultiplicity.MANY;
                            } else {
                                NavigationSegment lastSegment = segments.get(segments.size() - 1);
                                boolean bl = many = lastSegment.getKeyPredicates().isEmpty() && lastSegment.getNavigationProperty().getMultiplicity() == EdmMultiplicity.MANY;
                            }
                            if (isCount) {
                                if (many) {
                                    uriType = isLinks ? UriType.URI50B : UriType.URI15;
                                    break;
                                }
                                uriType = UriType.URI50A;
                                break;
                            }
                            if (many) {
                                uriType = isLinks ? UriType.URI7B : UriType.URI6B;
                                break;
                            }
                            uriType = isLinks ? UriType.URI7A : UriType.URI6A;
                            break;
                        }
                        break block24;
                    }
                    default: {
                        throw new ODataApplicationException("Unexpected property type " + (Object)((Object)targetKind), Locale.ENGLISH);
                    }
                }
                break block24;
            }
            EdmFunctionImport functionImport = uriInfo.getFunctionImport();
            EdmType targetType = uriInfo.getTargetType();
            boolean isCollection = functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY;
            switch (targetType.getKind()) {
                case SIMPLE: {
                    uriType = isCollection ? UriType.URI13 : UriType.URI14;
                    break;
                }
                case COMPLEX: {
                    uriType = isCollection ? UriType.URI11 : UriType.URI12;
                    break;
                }
                case ENTITY: {
                    uriType = UriType.URI10;
                    break;
                }
                default: {
                    throw new ODataApplicationException("Invalid function return type " + targetType, Locale.ENGLISH);
                }
            }
        }
        this.uriType = uriType;
    }

    public UriType getUriType() {
        return this.uriType;
    }

    @Override
    public EdmEntityContainer getEntityContainer() {
        return this.uriInfo.getEntityContainer();
    }

    @Override
    public EdmEntitySet getStartEntitySet() {
        return this.uriInfo.getStartEntitySet();
    }

    @Override
    public EdmEntitySet getTargetEntitySet() {
        return this.uriInfo.getTargetEntitySet();
    }

    @Override
    public EdmFunctionImport getFunctionImport() {
        return this.uriInfo.getFunctionImport();
    }

    @Override
    public EdmType getTargetType() {
        return this.uriInfo.getTargetType();
    }

    @Override
    public List<KeyPredicate> getKeyPredicates() {
        return this.uriInfo.getKeyPredicates();
    }

    @Override
    public List<KeyPredicate> getTargetKeyPredicates() {
        return this.uriInfo.getTargetKeyPredicates();
    }

    @Override
    public List<NavigationSegment> getNavigationSegments() {
        return this.uriInfo.getNavigationSegments();
    }

    @Override
    public List<EdmProperty> getPropertyPath() {
        return this.uriInfo.getPropertyPath();
    }

    @Override
    public boolean isCount() {
        return this.uriInfo.isCount();
    }

    @Override
    public boolean isValue() {
        return this.uriInfo.isValue();
    }

    @Override
    public boolean isLinks() {
        return this.uriInfo.isLinks();
    }

    @Override
    public String getFormat() {
        return this.uriInfo.getFormat();
    }

    @Override
    public FilterExpression getFilter() {
        return this.uriInfo.getFilter();
    }

    @Override
    public InlineCount getInlineCount() {
        return this.uriInfo.getInlineCount();
    }

    @Override
    public OrderByExpression getOrderBy() {
        return this.uriInfo.getOrderBy();
    }

    @Override
    public String getSkipToken() {
        return this.uriInfo.getSkipToken();
    }

    @Override
    public Integer getSkip() {
        return this.uriInfo.getSkip();
    }

    @Override
    public Integer getTop() {
        return this.uriInfo.getTop();
    }

    @Override
    public List<ArrayList<NavigationPropertySegment>> getExpand() {
        return this.uriInfo.getExpand();
    }

    @Override
    public List<SelectItem> getSelect() {
        return this.uriInfo.getSelect();
    }

    @Override
    public Map<String, EdmLiteral> getFunctionImportParameters() {
        return this.uriInfo.getFunctionImportParameters();
    }

    @Override
    public Map<String, String> getCustomQueryOptions() {
        return this.uriInfo.getCustomQueryOptions();
    }
}

