/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2.api.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.camel.component.olingo2.api.Olingo2ResponseHandler;
import org.apache.camel.component.olingo2.api.impl.Olingo2Helper;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;

public abstract class AbstractFutureCallback<T>
implements FutureCallback<HttpResponse> {
    public static final Pattern ODATA_MIME_TYPE = Pattern.compile("application/((atom)|(json)|(xml)).*");
    private final Olingo2ResponseHandler<T> responseHandler;

    AbstractFutureCallback(Olingo2ResponseHandler<T> responseHandler) {
        this.responseHandler = responseHandler;
    }

    public static HttpStatusCodes checkStatus(HttpResponse response) throws ODataApplicationException {
        StatusLine statusLine = response.getStatusLine();
        HttpStatusCodes httpStatusCode = HttpStatusCodes.fromStatusCode(statusLine.getStatusCode());
        if (400 <= httpStatusCode.getStatusCode() && httpStatusCode.getStatusCode() <= 599) {
            if (response.getEntity() != null) {
                try {
                    ContentType responseContentType = Olingo2Helper.getContentTypeHeader(response);
                    String mimeType = responseContentType.getMimeType();
                    if (ODATA_MIME_TYPE.matcher(mimeType).matches()) {
                        ODataErrorContext errorContext = EntityProvider.readErrorDocument(response.getEntity().getContent(), responseContentType.toString());
                        throw new ODataApplicationException(errorContext.getMessage(), errorContext.getLocale(), httpStatusCode, errorContext.getErrorCode(), errorContext.getException());
                    }
                }
                catch (EntityProviderException e) {
                    throw new ODataApplicationException(e.getMessage(), response.getLocale(), httpStatusCode, (Throwable)e);
                }
                catch (IOException e) {
                    throw new ODataApplicationException(e.getMessage(), response.getLocale(), httpStatusCode, (Throwable)e);
                }
            }
            throw new ODataApplicationException(statusLine.getReasonPhrase(), response.getLocale(), httpStatusCode);
        }
        return httpStatusCode;
    }

    @Override
    public final void completed(HttpResponse result) {
        try {
            AbstractFutureCallback.checkStatus(result);
            this.onCompleted(result);
        }
        catch (Exception e) {
            this.failed(e);
        }
        finally {
            if (result instanceof Closeable) {
                try {
                    ((Closeable)((Object)result)).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract void onCompleted(HttpResponse var1) throws ODataException, IOException;

    @Override
    public final void failed(Exception ex) {
        this.responseHandler.onException(ex);
    }

    @Override
    public final void cancelled() {
        this.responseHandler.onCanceled();
    }
}

