/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchParserResult;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.batch.BatchRequestPartImpl;
import org.apache.olingo.odata2.core.batch.v2.BatchBodyPart;
import org.apache.olingo.odata2.core.batch.v2.BatchChangeSetPart;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.BatchPart;
import org.apache.olingo.odata2.core.batch.v2.BatchQueryOperation;
import org.apache.olingo.odata2.core.batch.v2.BatchTransformator;
import org.apache.olingo.odata2.core.batch.v2.BatchTransformatorCommon;
import org.apache.olingo.odata2.core.batch.v2.Header;

public class BatchRequestTransformator
implements BatchTransformator {
    @Override
    public List<BatchParserResult> transform(BatchBodyPart bodyPart, PathInfo pathInfo, String baseUri) throws BatchException {
        LinkedList<ODataRequest> requests = new LinkedList<ODataRequest>();
        ArrayList<BatchParserResult> resultList = new ArrayList<BatchParserResult>();
        this.validateHeader(bodyPart, false);
        for (BatchQueryOperation queryOperation : bodyPart.getRequests()) {
            requests.add(this.processQueryOperation(bodyPart, pathInfo, baseUri, queryOperation));
        }
        resultList.add(new BatchRequestPartImpl(bodyPart.isChangeSet(), requests));
        return resultList;
    }

    private void validateHeader(BatchPart bodyPart, boolean isChangeSet) throws BatchException {
        Header headers = bodyPart.getHeaders();
        BatchTransformatorCommon.validateContentType(headers);
        BatchTransformatorCommon.validateContentTransferEncoding(headers, isChangeSet);
    }

    private ODataRequest processQueryOperation(BatchBodyPart bodyPart, PathInfo pathInfo, String baseUri, BatchQueryOperation queryOperation) throws BatchException {
        if (bodyPart.isChangeSet()) {
            BatchQueryOperation encapsulatedQueryOperation = ((BatchChangeSetPart)queryOperation).getRequest();
            Header headers = this.transformHeader(encapsulatedQueryOperation, queryOperation);
            this.validateHeader(queryOperation, true);
            return this.createRequest(queryOperation, headers, pathInfo, baseUri, bodyPart.isChangeSet());
        }
        Header headers = this.transformHeader(queryOperation, bodyPart);
        return this.createRequest(queryOperation, headers, pathInfo, baseUri, bodyPart.isChangeSet());
    }

    private ODataRequest createRequest(BatchQueryOperation operation, Header headers, PathInfo pathInfo, String baseUri, boolean isChangeSet) throws BatchException {
        BatchTransformatorCommon.HttpRequestStatusLine statusLine = new BatchTransformatorCommon.HttpRequestStatusLine(operation.getHttpStatusLine(), baseUri, pathInfo);
        statusLine.validateHttpMethod(isChangeSet);
        BatchTransformatorCommon.validateHost(headers, baseUri);
        this.validateBody(statusLine, operation);
        InputStream bodyStream = this.getBodyStream(operation, headers, statusLine);
        ODataRequest.ODataRequestBuilder requestBuilder = ODataRequest.method(statusLine.getMethod()).acceptableLanguages(this.getAcceptLanguageHeaders(headers)).acceptHeaders(headers.getHeaders("Accept")).allQueryParameters(BatchParserCommon.parseQueryParameter(operation.getHttpStatusLine())).body(bodyStream).requestHeaders(headers.toMultiMap()).pathInfo(statusLine.getPathInfo());
        String contentType = headers.getHeader("Content-Type");
        if (contentType != null) {
            requestBuilder.contentType(contentType);
        }
        return requestBuilder.build();
    }

    private void validateBody(BatchTransformatorCommon.HttpRequestStatusLine httpStatusLine, BatchQueryOperation operation) throws BatchException {
        if (httpStatusLine.getMethod().equals((Object)ODataHttpMethod.GET) && this.isUnvalidGetRequestBody(operation)) {
            throw new BatchException(BatchException.INVALID_BODY_FOR_REQUEST.addContent(httpStatusLine.getLineNumber()));
        }
    }

    private boolean isUnvalidGetRequestBody(BatchQueryOperation operation) {
        return operation.getBody().size() > 1 || operation.getBody().size() == 1 && !"".equals(operation.getBody().get(0).toString().trim());
    }

    private InputStream getBodyStream(BatchQueryOperation operation, Header headers, BatchTransformatorCommon.HttpRequestStatusLine httpStatusLine) throws BatchException {
        if (httpStatusLine.getMethod().equals((Object)ODataHttpMethod.GET)) {
            return new ByteArrayInputStream(new byte[0]);
        }
        int contentLength = BatchTransformatorCommon.getContentLength(headers);
        String contentType = headers.getHeader("Content-Type");
        return BatchParserCommon.convertToInputStream(contentType, operation.getBody(), contentLength);
    }

    private Header transformHeader(BatchPart operation, BatchPart parentPart) {
        Header headers = operation.getHeaders().clone();
        headers.removeHeader("Content-Id");
        Header.HeaderField operationHeader = operation.getHeaders().getHeaderField("Content-Id");
        Header.HeaderField parentHeader = parentPart.getHeaders().getHeaderField("Content-Id");
        if (operationHeader != null && operationHeader.getValues().size() != 0) {
            headers.addHeader("RequestHeader-ContentId", operationHeader.getValues(), operationHeader.getLineNumber());
        }
        if (parentHeader != null && parentHeader.getValues().size() != 0) {
            headers.addHeader("MimeHeader-ContentId", parentHeader.getValues(), parentHeader.getLineNumber());
        }
        return headers;
    }

    private List<Locale> getAcceptLanguageHeaders(Header headers) {
        List<String> acceptLanguageValues = headers.getHeaders("Accept-Language");
        ArrayList<Locale> acceptLanguages = new ArrayList<Locale>();
        for (String acceptLanguage : acceptLanguageValues) {
            String[] part = acceptLanguage.split("-");
            String language = part[0];
            String country = "";
            if (part.length == 2) {
                country = part[part.length - 1];
            }
            Locale locale = new Locale(language, country);
            acceptLanguages.add(locale);
        }
        return acceptLanguages;
    }
}

