/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.batch.BatchParserResult;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.core.batch.BatchSingleResponseImpl;
import org.apache.olingo.odata2.core.batch.v2.BatchBodyPart;
import org.apache.olingo.odata2.core.batch.v2.BatchChangeSetPart;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.BatchQueryOperation;
import org.apache.olingo.odata2.core.batch.v2.BatchTransformator;
import org.apache.olingo.odata2.core.batch.v2.BatchTransformatorCommon;

public class BatchResponseTransformator
implements BatchTransformator {
    @Override
    public List<BatchParserResult> transform(BatchBodyPart bodyPart, PathInfo pathInfo, String baseUri) throws BatchException {
        return this.processQueryOperation(bodyPart, pathInfo, baseUri);
    }

    private List<BatchParserResult> processQueryOperation(BatchBodyPart bodyPart, PathInfo pathInfo, String baseUri) throws BatchException {
        ArrayList<BatchParserResult> resultList = new ArrayList<BatchParserResult>();
        BatchTransformatorCommon.validateContentType(bodyPart.getHeaders());
        resultList.addAll(this.handleBodyPart(bodyPart));
        return resultList;
    }

    private List<BatchParserResult> handleBodyPart(BatchBodyPart bodyPart) throws BatchException {
        ArrayList<BatchParserResult> bodyPartResult = new ArrayList<BatchParserResult>();
        if (bodyPart.isChangeSet()) {
            for (BatchQueryOperation operation : bodyPart.getRequests()) {
                bodyPartResult.add(this.transformChangeSet((BatchChangeSetPart)operation));
            }
        } else {
            String contentId = bodyPart.getHeaders().getHeader("Content-Id");
            bodyPartResult.add(this.transformQueryOperation(bodyPart.getRequests().get(0), contentId));
        }
        return bodyPartResult;
    }

    private BatchSingleResponse transformChangeSet(BatchChangeSetPart changeSet) throws BatchException {
        BatchTransformatorCommon.validateContentTransferEncoding(changeSet.getHeaders(), true);
        String contentId = changeSet.getHeaders().getHeader("Content-Id");
        return this.transformQueryOperation(changeSet.getRequest(), contentId);
    }

    private BatchSingleResponse transformQueryOperation(BatchQueryOperation operation, String contentId) throws BatchException {
        BatchTransformatorCommon.HttpResponsetStatusLine statusLine = new BatchTransformatorCommon.HttpResponsetStatusLine(operation.getHttpStatusLine());
        BatchSingleResponseImpl response = new BatchSingleResponseImpl();
        response.setContentId(contentId);
        response.setHeaders(operation.getHeaders().toSingleMap());
        response.setStatusCode(statusLine.getStatusCode());
        response.setStatusInfo(statusLine.getStatusInfo());
        response.setBody(this.getBody(operation));
        return response;
    }

    private String getBody(BatchQueryOperation operation) throws BatchException {
        int contentLength = BatchTransformatorCommon.getContentLength(operation.getHeaders());
        if (contentLength == -1) {
            return BatchParserCommon.lineListToString(operation.getBody());
        }
        return BatchParserCommon.trimLineListToLength(operation.getBody(), contentLength);
    }
}

