/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.edm.provider.EdmEntitySetInfoImplProv;
import org.apache.olingo.odata2.core.ep.producer.XmlMetadataProducer;
import org.apache.olingo.odata2.core.ep.util.CircleStreamBuffer;

public class EdmServiceMetadataImplProv
implements EdmServiceMetadata {
    private EdmProvider edmProvider;
    private String dataServiceVersion;
    private List<Schema> schemas;
    private List<EdmEntitySetInfo> entitySetInfos;

    public EdmServiceMetadataImplProv(EdmProvider edmProvider) {
        this.edmProvider = edmProvider;
    }

    @Override
    public InputStream getMetadata() throws ODataException {
        if (this.schemas == null) {
            this.schemas = this.edmProvider.getSchemas();
        }
        OutputStreamWriter writer = null;
        CircleStreamBuffer csb = new CircleStreamBuffer();
        EntityProviderException cachedException = null;
        DataServices metadata = new DataServices().setSchemas(this.schemas).setDataServiceVersion(this.getDataServiceVersion());
        try {
            writer = new OutputStreamWriter(csb.getOutputStream(), "UTF-8");
            XMLStreamWriter xmlStreamWriter = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(writer);
            XmlMetadataProducer.writeMetadata(metadata, xmlStreamWriter, null);
            InputStream inputStream = csb.getInputStream();
            return inputStream;
        }
        catch (XMLStreamException e) {
            cachedException = new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            throw cachedException;
        }
        catch (UnsupportedEncodingException e) {
            cachedException = new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            throw cachedException;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getDataServiceVersion() throws ODataException {
        if (this.schemas == null) {
            this.schemas = this.edmProvider.getSchemas();
        }
        if (this.dataServiceVersion == null) {
            this.dataServiceVersion = "1.0";
            for (Schema schema : this.listOrEmptyList(this.schemas)) {
                List<EntityType> entityTypes = this.listOrEmptyList(schema.getEntityTypes());
                for (EntityType entityType : entityTypes) {
                    List<Property> properties = this.listOrEmptyList(entityType.getProperties());
                    for (Property property : properties) {
                        if (property.getCustomizableFeedMappings() == null) continue;
                        if (property.getCustomizableFeedMappings().getFcKeepInContent() != null && !property.getCustomizableFeedMappings().getFcKeepInContent().booleanValue()) {
                            this.dataServiceVersion = "2.0";
                            return this.dataServiceVersion;
                        }
                        if (entityType.getCustomizableFeedMappings() == null || entityType.getCustomizableFeedMappings().getFcKeepInContent() == null || !entityType.getCustomizableFeedMappings().getFcKeepInContent().booleanValue()) continue;
                        this.dataServiceVersion = "2.0";
                        return this.dataServiceVersion;
                    }
                }
            }
        }
        return this.dataServiceVersion;
    }

    @Override
    public List<EdmEntitySetInfo> getEntitySetInfos() throws ODataException {
        if (this.entitySetInfos == null) {
            this.entitySetInfos = new ArrayList<EdmEntitySetInfo>();
            if (this.schemas == null) {
                this.schemas = this.edmProvider.getSchemas();
            }
            for (Schema schema : this.schemas) {
                for (EntityContainer entityContainer : this.listOrEmptyList(schema.getEntityContainers())) {
                    for (EntitySet entitySet : this.listOrEmptyList(entityContainer.getEntitySets())) {
                        EdmEntitySetInfoImplProv entitySetInfo = new EdmEntitySetInfoImplProv(entitySet, entityContainer);
                        this.entitySetInfos.add(entitySetInfo);
                    }
                }
            }
        }
        return this.entitySetInfos;
    }

    private <T> List<T> listOrEmptyList(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }
}

