/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.FilterParserExceptionImpl;
import org.apache.olingo.odata2.core.uri.expression.FilterParserImpl;
import org.apache.olingo.odata2.core.uri.expression.OrderByExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.OrderByParser;
import org.apache.olingo.odata2.core.uri.expression.OrderExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;
import org.apache.olingo.odata2.core.uri.expression.Tokenizer;
import org.apache.olingo.odata2.core.uri.expression.TokenizerException;

public class OrderByParserImpl
extends FilterParserImpl
implements OrderByParser {
    public OrderByParserImpl(EdmEntityType resourceEntityType) {
        super(resourceEntityType);
    }

    @Override
    public OrderByExpression parseOrderByString(String orderByExpression) throws ExpressionParserException, ExpressionParserInternalError {
        OrderByExpressionImpl orderCollection;
        block13: {
            Token token;
            block14: {
                Token oldToken;
                this.curExpression = orderByExpression;
                orderCollection = new OrderByExpressionImpl(this.curExpression);
                try {
                    this.tokenList = new Tokenizer(orderByExpression).tokenize();
                }
                catch (TokenizerException tokenizerException) {
                    throw FilterParserExceptionImpl.createERROR_IN_TOKENIZER(tokenizerException, this.curExpression);
                }
                do {
                    CommonExpression node = null;
                    try {
                        CommonExpression nodeLeft = this.readElement(null);
                        node = this.readElements(nodeLeft, 0);
                    }
                    catch (ExpressionParserException expressionException) {
                        expressionException.setFilterTree(orderCollection);
                        throw expressionException;
                    }
                    OrderExpressionImpl orderNode = new OrderExpressionImpl(node);
                    token = this.tokenList.lookToken();
                    if (token == null) {
                        orderNode.setSortOrder(SortOrder.asc);
                    } else if (token.getKind() == TokenKind.LITERAL && token.getUriLiteral().equals("asc")) {
                        orderNode.setSortOrder(SortOrder.asc);
                        this.tokenList.next();
                        token = this.tokenList.lookToken();
                    } else if (token.getKind() == TokenKind.LITERAL && token.getUriLiteral().equals("desc")) {
                        orderNode.setSortOrder(SortOrder.desc);
                        this.tokenList.next();
                        token = this.tokenList.lookToken();
                    } else if (token.getKind() == TokenKind.COMMA) {
                        orderNode.setSortOrder(SortOrder.asc);
                    } else {
                        throw FilterParserExceptionImpl.createINVALID_SORT_ORDER(token, this.curExpression);
                    }
                    orderCollection.addOrder(orderNode);
                    if (token == null) break block13;
                    if (token.getKind() != TokenKind.COMMA) break block14;
                    oldToken = token;
                    this.tokenList.next();
                } while ((token = this.tokenList.lookToken()) != null);
                throw FilterParserExceptionImpl.createEXPRESSION_EXPECTED_AFTER_POS(oldToken, this.curExpression);
            }
            throw FilterParserExceptionImpl.createCOMMA_OR_END_EXPECTED_AT_POS(token, this.curExpression);
        }
        return orderCollection;
    }
}

