/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.XmlLinkEntityProducer;

public class XmlLinksEntityProducer {
    private final EntityProviderWriteProperties properties;

    public XmlLinksEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data) throws EntityProviderException {
        try {
            writer.writeStartElement("links");
            writer.writeDefaultNamespace("http://schemas.microsoft.com/ado/2007/08/dataservices");
            if (this.properties.getInlineCount() != null) {
                writer.writeStartElement("m", "count", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeCharacters(this.properties.getInlineCount().toString());
                writer.writeEndElement();
            }
            XmlLinkEntityProducer provider = new XmlLinkEntityProducer(this.properties);
            for (Map<String, Object> entityData : data) {
                provider.append(writer, entityInfo, entityData, false);
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }
}

