/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmComplexPropertyImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNamedImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;

public abstract class EdmStructuralTypeImplProv
extends EdmNamedImplProv
implements EdmStructuralType,
EdmAnnotatable {
    protected EdmStructuralType edmBaseType;
    protected ComplexType structuralType;
    private EdmTypeKind edmTypeKind;
    protected String namespace;
    protected Map<String, EdmTyped> edmProperties;
    private Map<String, Property> properties;
    private List<String> edmPropertyNames;
    private EdmAnnotations annotations;

    public EdmStructuralTypeImplProv(EdmImplProv edm, ComplexType structuralType, EdmTypeKind edmTypeKind, String namespace) throws EdmException {
        super(edm, structuralType.getName());
        this.structuralType = structuralType;
        this.namespace = namespace;
        this.edmTypeKind = edmTypeKind;
        this.resolveBaseType();
        this.buildPropertiesInternal();
        this.edmProperties = new HashMap<String, EdmTyped>();
    }

    private void resolveBaseType() throws EdmException {
        FullQualifiedName fqName = this.structuralType.getBaseType();
        if (fqName != null) {
            if (EdmTypeKind.COMPLEX.equals((Object)this.edmTypeKind)) {
                this.edmBaseType = this.edm.getComplexType(fqName.getNamespace(), fqName.getName());
            } else if (EdmTypeKind.ENTITY.equals((Object)this.edmTypeKind)) {
                this.edmBaseType = this.edm.getEntityType(fqName.getNamespace(), fqName.getName());
            }
            if (this.edmBaseType == null) {
                throw new EdmException(EdmException.COMMON);
            }
        }
    }

    private void buildPropertiesInternal() throws EdmException {
        this.properties = new HashMap<String, Property>();
        if (this.structuralType.getProperties() != null) {
            for (Property property : this.structuralType.getProperties()) {
                this.properties.put(property.getName(), property);
            }
        }
    }

    @Override
    public String getNamespace() throws EdmException {
        return this.namespace;
    }

    @Override
    public EdmTyped getProperty(String name) throws EdmException {
        EdmTyped property = this.edmProperties.get(name);
        if (property == null && (property = this.getPropertyInternal(name)) == null && this.edmBaseType != null) {
            property = this.edmBaseType.getProperty(name);
        }
        return property;
    }

    @Override
    public List<String> getPropertyNames() throws EdmException {
        if (this.edmPropertyNames == null) {
            ArrayList<String> temp = new ArrayList<String>();
            if (this.edmBaseType != null) {
                temp.addAll(this.edmBaseType.getPropertyNames());
            }
            if (this.structuralType.getProperties() != null) {
                for (Property property : this.structuralType.getProperties()) {
                    temp.add(property.getName());
                }
            }
            this.edmPropertyNames = temp;
        }
        return this.edmPropertyNames;
    }

    @Override
    public EdmStructuralType getBaseType() throws EdmException {
        return this.edmBaseType;
    }

    @Override
    public EdmTypeKind getKind() {
        return this.edmTypeKind;
    }

    @Override
    public EdmMapping getMapping() throws EdmException {
        return this.structuralType.getMapping();
    }

    protected EdmTyped getPropertyInternal(String name) throws EdmException {
        EdmTyped edmProperty = null;
        if (this.properties.containsKey(name)) {
            edmProperty = this.createProperty(this.properties.get(name));
            this.edmProperties.put(name, edmProperty);
        } else if (this.edmBaseType != null && (edmProperty = this.edmBaseType.getProperty(name)) != null) {
            this.edmProperties.put(name, edmProperty);
        }
        return edmProperty;
    }

    protected EdmTyped createProperty(Property property) throws EdmException {
        if (property instanceof SimpleProperty) {
            return new EdmSimplePropertyImplProv(this.edm, (SimpleProperty)property);
        }
        if (property instanceof ComplexProperty) {
            return new EdmComplexPropertyImplProv(this.edm, (ComplexProperty)property);
        }
        throw new EdmException(EdmException.COMMON);
    }

    public String toString() {
        try {
            return this.namespace + "." + this.getName();
        }
        catch (EdmException e) {
            return null;
        }
    }

    @Override
    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.structuralType.getAnnotationAttributes(), this.structuralType.getAnnotationElements());
        }
        return this.annotations;
    }
}

