/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.servicedocument.ServiceDocument;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.ep.ContentTypeBasedEntityProvider;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.consumer.AtomServiceDocumentConsumer;
import org.apache.olingo.odata2.core.ep.consumer.XmlEntityConsumer;
import org.apache.olingo.odata2.core.ep.consumer.XmlErrorDocumentConsumer;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.AtomFeedProducer;
import org.apache.olingo.odata2.core.ep.producer.AtomServiceDocumentProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlCollectionEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlErrorDocumentProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlLinkEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlLinksEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlPropertyEntityProducer;
import org.apache.olingo.odata2.core.ep.util.CircleStreamBuffer;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class AtomEntityProvider
implements ContentTypeBasedEntityProvider {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String XML_VERSION = "1.0";

    public AtomEntityProvider() throws EntityProviderException {
        this(ContentType.ODataFormat.ATOM);
    }

    public AtomEntityProvider(ContentType.ODataFormat odataFormat) throws EntityProviderException {
        if (odataFormat != ContentType.ODataFormat.ATOM && odataFormat != ContentType.ODataFormat.XML) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent("Got unsupported ODataFormat '" + (Object)((Object)odataFormat) + "'."));
        }
    }

    @Override
    public ODataResponse writeErrorDocument(HttpStatusCodes status, String errorCode, String message, Locale locale, String innerError) {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            XmlErrorDocumentProducer producer = new XmlErrorDocumentProducer();
            producer.writeErrorDocument(writer, errorCode, message, locale, innerError);
            writer.flush();
            csb.closeWrite();
            ODataResponse.ODataResponseBuilder response = ODataResponse.entity(csb.getInputStream()).header("DataServiceVersion", XML_VERSION).status(status);
            return response.build();
        }
        catch (Exception e) {
            csb.close();
            throw new ODataRuntimeException(e);
        }
    }

    @Override
    public ODataResponse writeServiceDocument(Edm edm, String serviceRoot) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(csb.getOutputStream(), DEFAULT_CHARSET);
            AtomServiceDocumentProducer as = new AtomServiceDocumentProducer(edm, serviceRoot);
            as.writeServiceDocument(writer);
            csb.closeWrite();
            return ODataResponse.entity(csb.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeEntry(EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            AtomEntryEntityProducer as = new AtomEntryEntityProducer(properties);
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
            as.append(writer, eia, data, true, false);
            writer.flush();
            csb.closeWrite();
            ODataResponse.ODataResponseBuilder response = ODataResponse.entity(csb.getInputStream()).eTag(as.getETag()).idLiteral(as.getLocation());
            return response.build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeProperty(EdmProperty edmProperty, Object value) throws EntityProviderException {
        EntityPropertyInfo propertyInfo = EntityInfoAggregator.create(edmProperty);
        return this.writeSingleTypedElement(propertyInfo, value);
    }

    private ODataResponse writeSingleTypedElement(EntityPropertyInfo propertyInfo, Object value) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            XmlPropertyEntityProducer ps = new XmlPropertyEntityProducer(false, true);
            ps.append(writer, propertyInfo, value);
            writer.flush();
            csb.closeWrite();
            return ODataResponse.entity(csb.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeFeed(EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            AtomFeedProducer atomFeedProvider = new AtomFeedProducer(properties);
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
            atomFeedProvider.append(writer, eia, data, false);
            writer.flush();
            csb.closeWrite();
            ODataResponse response = ODataResponse.entity(csb.getInputStream()).build();
            return response;
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (XMLStreamException e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeLink(EdmEntitySet entitySet, Map<String, Object> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            XmlLinkEntityProducer entity = new XmlLinkEntityProducer(properties);
            EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
            entity.append(writer, entityInfo, data, true);
            writer.flush();
            csb.closeWrite();
            return ODataResponse.entity(csb.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeLinks(EdmEntitySet entitySet, List<Map<String, Object>> data, EntityProviderWriteProperties properties) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            XmlLinksEntityProducer entity = new XmlLinksEntityProducer(properties);
            EntityInfoAggregator entityInfo = EntityInfoAggregator.create(entitySet, properties.getExpandSelectTree());
            entity.append(writer, entityInfo, data);
            writer.flush();
            csb.closeWrite();
            return ODataResponse.entity(csb.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private ODataResponse writeCollection(EntityPropertyInfo propertyInfo, List<?> data) throws EntityProviderException {
        CircleStreamBuffer csb = new CircleStreamBuffer();
        try {
            OutputStream outStream = csb.getOutputStream();
            XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outStream, DEFAULT_CHARSET);
            writer.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            XmlCollectionEntityProducer.append(writer, propertyInfo, data);
            writer.flush();
            csb.closeWrite();
            return ODataResponse.entity(csb.getInputStream()).build();
        }
        catch (EntityProviderException e) {
            csb.close();
            throw e;
        }
        catch (Exception e) {
            csb.close();
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public ODataResponse writeFunctionImport(EdmFunctionImport functionImport, Object data, EntityProviderWriteProperties properties) throws EntityProviderException {
        try {
            if (functionImport.getReturnType() != null) {
                boolean isCollection;
                EdmType type = functionImport.getReturnType().getType();
                boolean bl = isCollection = functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY;
                if (type.getKind() == EdmTypeKind.ENTITY) {
                    Map map = (Map)data;
                    return this.writeEntry(functionImport.getEntitySet(), map, properties);
                }
                EntityPropertyInfo info = EntityInfoAggregator.create(functionImport);
                if (isCollection) {
                    return this.writeCollection(info, (List)data);
                }
                return this.writeSingleTypedElement(info, data);
            }
            return ODataResponse.newBuilder().status(HttpStatusCodes.ACCEPTED).build();
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    @Override
    public ODataFeed readFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        return this.readDeltaFeed(entitySet, content, properties);
    }

    @Override
    public ODataDeltaFeed readDeltaFeed(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        XmlEntityConsumer xec = new XmlEntityConsumer();
        return xec.readFeed(entitySet, content, properties);
    }

    @Override
    public ODataEntry readEntry(EdmEntitySet entitySet, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        XmlEntityConsumer xec = new XmlEntityConsumer();
        return xec.readEntry(entitySet, content, properties);
    }

    @Override
    public Map<String, Object> readProperty(EdmProperty edmProperty, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        XmlEntityConsumer xec = new XmlEntityConsumer();
        return xec.readProperty(edmProperty, content, properties);
    }

    @Override
    public String readLink(EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        XmlEntityConsumer xec = new XmlEntityConsumer();
        return xec.readLink(entitySet, content);
    }

    @Override
    public List<String> readLinks(EdmEntitySet entitySet, InputStream content) throws EntityProviderException {
        XmlEntityConsumer xec = new XmlEntityConsumer();
        return xec.readLinks(entitySet, content);
    }

    @Override
    public ServiceDocument readServiceDocument(InputStream serviceDocument) throws EntityProviderException {
        AtomServiceDocumentConsumer serviceDocConsumer = new AtomServiceDocumentConsumer();
        return serviceDocConsumer.parseXml(serviceDocument);
    }

    @Override
    public ODataErrorContext readErrorDocument(InputStream errorDocument) throws EntityProviderException {
        XmlErrorDocumentConsumer xmlErrorDocumentConsumer = new XmlErrorDocumentConsumer();
        return xmlErrorDocumentConsumer.readError(errorDocument);
    }

    @Override
    public Object readFunctionImport(EdmFunctionImport functionImport, InputStream content, EntityProviderReadProperties properties) throws EntityProviderException {
        try {
            if (functionImport.getReturnType().getType().getKind() == EdmTypeKind.ENTITY) {
                return new XmlEntityConsumer().readEntry(functionImport.getEntitySet(), content, properties);
            }
            EntityPropertyInfo info = EntityInfoAggregator.create(functionImport);
            return functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY ? new XmlEntityConsumer().readCollection(info, content, properties) : new XmlEntityConsumer().readProperty(info, content, properties).get(info.getName());
        }
        catch (EdmException e) {
            throw new EntityProviderException(e.getMessageReference(), (Throwable)e);
        }
    }
}

