/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;

public class MemberExpressionImpl
implements BinaryExpression,
MemberExpression {
    CommonExpression path;
    CommonExpression property;
    EdmType edmType;

    public MemberExpressionImpl(CommonExpression path, CommonExpression property) {
        this.path = path;
        this.property = property;
        this.edmType = property.getEdmType();
    }

    @Override
    public CommonExpression getPath() {
        return this.path;
    }

    @Override
    public CommonExpression getProperty() {
        return this.property;
    }

    @Override
    public EdmType getEdmType() {
        return this.edmType;
    }

    @Override
    public CommonExpression setEdmType(EdmType edmType) {
        this.edmType = edmType;
        return this;
    }

    @Override
    public BinaryOperator getOperator() {
        return BinaryOperator.PROPERTY_ACCESS;
    }

    @Override
    public ExpressionKind getKind() {
        return ExpressionKind.MEMBER;
    }

    @Override
    public String getUriLiteral() {
        return BinaryOperator.PROPERTY_ACCESS.toUriLiteral();
    }

    @Override
    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        Object retSource = this.path.accept(visitor);
        Object retPath = this.property.accept(visitor);
        Object ret = visitor.visitMember(this, retSource, retPath);
        return ret;
    }

    @Override
    public CommonExpression getLeftOperand() {
        return this.path;
    }

    @Override
    public CommonExpression getRightOperand() {
        return this.property;
    }
}

