/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataEntityUpdateRequestImpl<E extends ClientEntity>
extends AbstractODataBasicRequest<ODataEntityUpdateResponse<E>>
implements ODataEntityUpdateRequest<E> {
    private final E changes;

    public ODataEntityUpdateRequestImpl(ODataClient odataClient, HttpMethod method, URI uri, E changes) {
        super(odataClient, method, uri);
        this.changes = changes;
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeEntity((ClientEntity)this.changes, ContentType.parse(this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODataEntityUpdateResponse<E> execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            HttpResponse httpResponse = this.doExecute();
            ODataEntityUpdateResponseImpl response = new ODataEntityUpdateResponseImpl(this.odataClient, this.httpClient, httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 204) {
                response.close();
            }
            ODataEntityUpdateResponseImpl oDataEntityUpdateResponseImpl = response;
            return oDataEntityUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private class ODataEntityUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataEntityUpdateResponse<E> {
        private E entity;

        private ODataEntityUpdateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.entity = null;
        }

        @Override
        public E getBody() {
            if (this.entity == null) {
                try {
                    ResWrap<Entity> resource = this.odataClient.getDeserializer(ContentType.parse(ODataEntityUpdateRequestImpl.this.getAccept())).toEntity(this.getRawResponse());
                    this.entity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.entity;
        }
    }
}

