/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.retrieve;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.response.ODataRawResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataRawRequestImpl
extends AbstractODataRequest
implements ODataRawRequest {
    ODataRawRequestImpl(ODataClient odataClient, URI uri) {
        super(odataClient, HttpMethod.GET, uri);
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public void setFormat(String format) {
        this.setAccept(format);
        this.setContentType(format);
    }

    @Override
    public ODataRawResponse execute() {
        return new ODataRawResponseImpl(this.odataClient, this.httpClient, this.doExecute());
    }

    private class ODataRawResponseImpl
    extends AbstractODataResponse
    implements ODataRawResponse {
        private byte[] obj;

        private ODataRawResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.obj = null;
        }

        @Override
        public <T> ResWrap<T> getBodyAs(Class<T> reference) {
            if (this.obj == null) {
                try {
                    this.obj = IOUtils.toByteArray((InputStream)this.getRawResponse());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            try {
                return this.odataClient.getReader().read(new ByteArrayInputStream(this.obj), this.getContentType(), reference);
            }
            catch (ODataDeserializerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

