/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.ODataImpl;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.apache.olingo.server.core.uri.parser.Parser;

public class UriHelperImpl
implements UriHelper {
    @Override
    public String buildContextURLSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(type, expand, select);
    }

    @Override
    public String buildContextURLKeyPredicate(List<UriParameter> keys) throws SerializerException {
        return ContextURLHelper.buildKeyPredicate(keys);
    }

    @Override
    public String buildCanonicalURL(EdmEntitySet edmEntitySet, Entity entity) throws SerializerException {
        return edmEntitySet.getName() + '(' + this.buildKeyPredicate(edmEntitySet.getEntityType(), entity) + ')';
    }

    @Override
    public String buildKeyPredicate(EdmEntityType edmEntityType, Entity entity) throws SerializerException {
        StringBuilder result = new StringBuilder();
        List<String> keyNames = edmEntityType.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            EdmProperty edmProperty;
            EdmKeyPropertyRef refType = edmEntityType.getKeyPropertyRef(keyName);
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode(keyName)).append('=');
            }
            if ((edmProperty = refType.getProperty()) == null) {
                throw new SerializerException("Property not found (possibly an alias): " + keyName, SerializerException.MessageKeys.MISSING_PROPERTY, keyName);
            }
            EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
            Object propertyValue = this.findPropertyRefValue(entity, refType);
            try {
                String value = type.toUriLiteral(type.valueToString(propertyValue, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode()));
                result.append(Encoder.encode(value));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong key value!", (Throwable)e, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, edmProperty.getName(), propertyValue != null ? propertyValue.toString() : null);
            }
        }
        return result.toString();
    }

    private Object findPropertyRefValue(Entity entity, EdmKeyPropertyRef refType) throws SerializerException {
        int INDEX_ERROR_CODE = -1;
        String propertyPath = refType.getName();
        int index = propertyPath.indexOf(47);
        if (index == -1) {
            index = propertyPath.length();
        }
        String tmpPropertyName = propertyPath.substring(0, index);
        Property prop = entity.getProperty(tmpPropertyName);
        while (index < propertyPath.length()) {
            int lastIndex = ++index;
            if ((index = propertyPath.indexOf(47, index + 1)) == -1) {
                index = propertyPath.length();
            }
            tmpPropertyName = propertyPath.substring(lastIndex, index);
            prop = this.findProperty(tmpPropertyName, prop.asComplex().getValue());
        }
        if (prop == null) {
            throw new SerializerException("Key Value Cannot be null for property: " + propertyPath, SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, propertyPath);
        }
        return prop.getValue();
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public UriResourceEntitySet parseEntityId(Edm edm, String entityId, String rawServiceRoot) throws DeserializerException {
        String oDataPath = entityId;
        if (rawServiceRoot != null && entityId.startsWith(rawServiceRoot)) {
            oDataPath = entityId.substring(rawServiceRoot.length());
        }
        oDataPath = oDataPath.startsWith("/") ? oDataPath : "/" + oDataPath;
        try {
            List<UriResource> uriResourceParts = new Parser(edm, new ODataImpl()).parseUri(oDataPath, null, null, rawServiceRoot).getUriResourceParts();
            if (uriResourceParts.size() == 1 && uriResourceParts.get(0).getKind() == UriResourceKind.entitySet) {
                UriResourceEntitySet entityUriResource = (UriResourceEntitySet)uriResourceParts.get(0);
                return entityUriResource;
            }
            throw new DeserializerException("Invalid entity binding link", DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, entityId);
        }
        catch (ODataLibraryException e) {
            throw new DeserializerException("Invalid entity binding link", (Throwable)e, DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, entityId);
        }
    }
}

