/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;

public class AddChannelItemCommand
extends AbstractCommand {
    public boolean _channelItemExists;
    public boolean _emptyChannelItems;
    public String _newChannelItemName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newChannelItemObj;

    AddChannelItemCommand() {
    }

    AddChannelItemCommand(String channelItemName, Object from) {
        this._newChannelItemName = channelItemName;
        this._newChannelItemObj = from;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddChannelItemCommand] Executing.", new Object[0]);
        AaiDocument doc = (AaiDocument)document;
        if (doc.channels != null && doc.channels.isEmpty()) {
            this._emptyChannelItems = true;
        }
        if (!this.isNullOrUndefined(doc.channels.get(this._newChannelItemName))) {
            LoggerCompat.info("[AddChannelItemCommand] AddChannelItemCommand with name %s already exists.", this._newChannelItemName);
            this._channelItemExists = true;
        } else {
            AaiChannelItem channelItem = doc.createChannelItem(this._newChannelItemName);
            doc.addChannelItem(channelItem);
            Library.readNode(this._newChannelItemObj, channelItem);
            this._channelItemExists = false;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddChannelItemCommand] Reverting.", new Object[0]);
        if (this._channelItemExists) {
            return;
        }
        AaiDocument doc = (AaiDocument)document;
        if (this._emptyChannelItems) {
            doc.channels.clear();
        } else {
            doc.channels.remove(this._newChannelItemName);
        }
    }
}

