/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.models.AaiOperation;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;

public class NewOperationCommand_Aai20
extends AbstractCommand {
    public String _channel;
    public String _opType;
    public boolean _created;

    NewOperationCommand_Aai20() {
    }

    NewOperationCommand_Aai20(String _channel, String opType) {
        this._channel = _channel;
        this._opType = opType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewOperationCommand_Aai20] Executing.", new Object[0]);
        AaiDocument adoc = (AaiDocument)document;
        this._created = false;
        if (this.isNullOrUndefined(adoc.channels)) {
            return;
        }
        AaiChannelItem channel = adoc.channels.get(this._channel);
        if (this.isNullOrUndefined(channel)) {
            return;
        }
        if (!"subscribe".equals(this._opType) && !"publish".equals(this._opType)) {
            return;
        }
        Aai20NodeFactory nodeFactory = new Aai20NodeFactory();
        AaiOperation operation = nodeFactory.createOperation(channel, this._opType);
        operation.message = nodeFactory.createMessage(operation, null);
        operation.message.payload = JsonCompat.objectNode();
        switch (this._opType) {
            case "subscribe": {
                channel.subscribe = operation;
                break;
            }
            case "publish": {
                channel.publish = operation;
            }
        }
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewOperationCommand_Aai20] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        AaiDocument adoc = (AaiDocument)document;
        if (this.isNullOrUndefined(adoc.channels)) {
            return;
        }
        AaiChannelItem channel = adoc.channels.get(this._channel);
        if (this.isNullOrUndefined(channel)) {
            return;
        }
        NodeCompat.setProperty(channel, this._opType, null);
    }
}

