/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.commands.NewSecuritySchemeCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;

public class NewSecuritySchemeCommand_20
extends NewSecuritySchemeCommand {
    public boolean _nullSecurityDefinitions;

    NewSecuritySchemeCommand_20() {
    }

    NewSecuritySchemeCommand_20(SecurityScheme scheme) {
        super(scheme);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewSecuritySchemeCommand] Executing.", new Object[0]);
        Oas20Document doc20 = (Oas20Document)document;
        this._nullSecurityDefinitions = false;
        if (this.isNullOrUndefined(doc20.securityDefinitions)) {
            doc20.securityDefinitions = doc20.createSecurityDefinitions();
            this._nullSecurityDefinitions = true;
        }
        if (this.isNullOrUndefined(doc20.securityDefinitions.getSecurityScheme(this._schemeName))) {
            Oas20SecurityScheme scheme = doc20.securityDefinitions.createSecurityScheme(this._schemeName);
            Library.readNode(this._scheme, scheme);
            doc20.securityDefinitions.addSecurityScheme(this._schemeName, scheme);
            this._schemeExisted = false;
        } else {
            this._schemeExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewSecuritySchemeCommand] Reverting.", new Object[0]);
        if (this._schemeExisted) {
            return;
        }
        Oas20Document doc20 = (Oas20Document)document;
        if (this._nullSecurityDefinitions) {
            doc20.securityDefinitions = null;
            return;
        }
        doc20.securityDefinitions.removeSecurityScheme(this._schemeName);
    }
}

