/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiChannelItem;
import io.apicurio.datamodels.asyncapi.models.AaiParameter;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RenameChannelItemCommand
extends AbstractCommand {
    public String _oldChannelName;
    public String _newChannelName;
    public boolean _channelExisted;
    public boolean _nullParams;
    @JsonIgnore
    public final Map<String, Object> _paramBin = new LinkedHashMap<String, Object>();
    @JsonIgnore
    public final Aai20NodeFactory _nodeFactory = new Aai20NodeFactory();

    RenameChannelItemCommand() {
    }

    RenameChannelItemCommand(String oldChannelName, String newChannelName) {
        this._oldChannelName = oldChannelName;
        this._newChannelName = newChannelName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameChannelItemCommand] Executing.", new Object[0]);
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isNullOrUndefined(aai20Document.channels)) {
            return;
        }
        if (aai20Document.channels.containsKey(this._newChannelName)) {
            this._channelExisted = true;
            return;
        }
        this._channelExisted = false;
        AaiChannelItem aaiChannel = (AaiChannelItem)aai20Document.channels.remove(this._oldChannelName);
        if (this.isNullOrUndefined(aaiChannel)) {
            return;
        }
        aaiChannel.rename(this._newChannelName);
        aai20Document.channels.put(this._newChannelName, aaiChannel);
        this._nullParams = ModelUtils.isNullOrUndefined(aaiChannel.parameters);
        this._doParametersRename(aaiChannel, this._oldChannelName, this._newChannelName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameChannelItemCommand] Reverting.", new Object[0]);
        Aai20Document aai20Document = (Aai20Document)document;
        if (ModelUtils.isNullOrUndefined(aai20Document.channels)) {
            return;
        }
        if (this._channelExisted) {
            return;
        }
        AaiChannelItem aaiChannel = (AaiChannelItem)aai20Document.channels.remove(this._newChannelName);
        if (this.isNullOrUndefined(aaiChannel)) {
            return;
        }
        aaiChannel.rename(this._oldChannelName);
        aai20Document.channels.put(this._oldChannelName, aaiChannel);
        if (this._nullParams) {
            NodeCompat.setProperty(aaiChannel, "parameters", null);
        } else {
            this._doParametersRename(aaiChannel, this._newChannelName, this._oldChannelName);
        }
    }

    private void _doParametersRename(AaiChannelItem aaiChannel, String from, String to) {
        List<String> fromChannelParamNames = ModelUtils.detectPathParamNames(from);
        List<String> toChannelParamNames = ModelUtils.detectPathParamNames(to);
        if (fromChannelParamNames.size() != toChannelParamNames.size()) {
            LoggerCompat.warn("Renaming a channel with %o parameters to a new value that has %o parameters!", fromChannelParamNames.size(), toChannelParamNames.size());
        }
        List<String[]> parameterRenames = this._processPathParameterRenames(fromChannelParamNames, toChannelParamNames);
        for (String[] namePair : parameterRenames) {
            if (ModelUtils.isNullOrUndefined(namePair[0])) {
                this._createChannelParameter(aaiChannel, namePair[1]);
                continue;
            }
            if (ModelUtils.isNullOrUndefined(namePair[1])) {
                this._removeChannelParameter(aaiChannel, namePair[0]);
                continue;
            }
            this._renameChannelParameter(aaiChannel, namePair[0], namePair[1]);
        }
        if (ModelUtils.isDefined(aaiChannel.parameters) && aaiChannel.parameters.isEmpty()) {
            NodeCompat.setProperty(aaiChannel, "parameters", null);
        }
    }

    private List<String[]> _processPathParameterRenames(List<String> fromChannelParamNames, List<String> toChannelParamNames) {
        int idx;
        ArrayList<String[]> ret = new ArrayList<String[]>();
        ArrayList knownParamNames = new ArrayList();
        ArrayList addedParamNames = new ArrayList();
        ArrayList removedParamNames = new ArrayList();
        fromChannelParamNames.forEach(name -> {
            if (!knownParamNames.contains(name)) {
                knownParamNames.add(name);
                if (!toChannelParamNames.contains(name)) {
                    removedParamNames.add(name);
                }
            }
        });
        toChannelParamNames.forEach(name -> {
            if (!knownParamNames.contains(name)) {
                knownParamNames.add(name);
                if (!fromChannelParamNames.contains(name)) {
                    addedParamNames.add(name);
                }
            }
        });
        int minIndex = Math.min(removedParamNames.size(), addedParamNames.size());
        for (idx = 0; idx < minIndex; ++idx) {
            ret.add(new String[]{(String)removedParamNames.get(idx), (String)addedParamNames.get(idx)});
        }
        while (idx < removedParamNames.size()) {
            ret.add(new String[]{(String)removedParamNames.get(idx), null});
            ++idx;
        }
        while (idx < addedParamNames.size()) {
            ret.add(new String[]{null, (String)addedParamNames.get(idx)});
            ++idx;
        }
        return ret;
    }

    private void _createChannelParameter(AaiChannelItem channel, String paramName) {
        Map<String, AaiParameter> parameters = channel.parameters;
        if (ModelUtils.isNullOrUndefined(parameters)) {
            parameters = new LinkedHashMap<String, AaiParameter>();
            NodeCompat.setProperty(channel, "parameters", parameters);
        }
        AaiParameter parameter = this._nodeFactory.createParameter(channel, paramName);
        Object restorable = this._paramBin.remove(paramName);
        if (ModelUtils.isDefined(restorable)) {
            Library.readNode(restorable, parameter);
        }
        parameters.put(paramName, parameter);
    }

    private void _renameChannelParameter(AaiChannelItem channel, String fromParamName, String toParamName) {
        AaiParameter param;
        if (ModelUtils.isDefined(channel.parameters) && ModelUtils.isDefined(param = channel.parameters.remove(fromParamName))) {
            param.rename(toParamName);
            channel.addParameter(toParamName, param);
        }
    }

    private void _removeChannelParameter(AaiChannelItem channel, String paramName) {
        if (this.isNullOrUndefined(channel.parameters)) {
            return;
        }
        AaiParameter removed = channel.parameters.remove(paramName);
        if (ModelUtils.isDefined(removed)) {
            this._paramBin.put(paramName, Library.writeNode(removed));
        }
    }
}

