/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.compat;

import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Node;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class NodeCompat {
    public static Object getProperty(Object node, String propertyName) {
        if ("default".equals(propertyName) || "enum".equals(propertyName)) {
            propertyName = propertyName + "_";
        }
        if (node instanceof Node) {
            try {
                Field field = node.getClass().getField(propertyName);
                return field.get(node);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                return null;
            }
        }
        if (node instanceof List) {
            int idx = Integer.parseInt(propertyName);
            List list = (List)node;
            return list.get(idx);
        }
        if (node instanceof Map) {
            Map map = (Map)node;
            return map.get(propertyName);
        }
        return null;
    }

    public static void setProperty(Object node, String propertyName, Object newValue) {
        try {
            Field field = node.getClass().getField(propertyName);
            field.set(node, newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LoggerCompat.warn("Failed to set property '%s' on Node '%s': %s", propertyName, node.getClass().getSimpleName(), e.getMessage());
            return;
        }
    }

    public static int indexOf(Node child, Node parent, String propertyName) {
        try {
            List array = (List)NodeCompat.getProperty(parent, propertyName);
            for (int idx = 0; idx < array.size(); ++idx) {
                Node node = (Node)array.get(idx);
                if (node != child) continue;
                return idx;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        return value1 != null && value1.equals(value2);
    }

    public static String join(String delim, List<String> values) {
        return String.join((CharSequence)delim, values);
    }

    public static String joinArray(String delim, String[] values) {
        return NodeCompat.join(delim, Arrays.asList(values));
    }

    public static boolean isNode(Object object) {
        return object != null && object instanceof Node;
    }

    public static boolean isList(Object object) {
        return object != null && object instanceof List;
    }

    public static String[] asArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static List<String> asList(String ... items) {
        return Arrays.asList(items);
    }

    public static List<String> copyList(List<String> list) {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(list);
        return rval;
    }

    public static boolean isNullOrUndefined(Object value) {
        return value == null;
    }

    public static boolean isDefined(Object value) {
        return !NodeCompat.isNullOrUndefined(value);
    }
}

