/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Components;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20SchemaDefinition;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.compat.RegexCompat;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.IDefinition;
import java.util.List;

public class AaiSchemaFactory {
    public static IDefinition createSchemaDefinitionFromExample(AaiDocument document, String name, Object example) {
        Aai20Document doc;
        if (document.getDocumentType() == DocumentType.asyncapi2) {
            doc = (Aai20Document)document;
            if (NodeCompat.isNullOrUndefined(doc.components)) {
                doc.components = doc.createComponents();
            }
        } else {
            throw new RuntimeException("Only AsyncAPI 2 is currently supported.");
        }
        Aai20SchemaDefinition schema = ((Aai20Components)doc.components).createSchemaDefinition(name);
        if (JsonCompat.isString(example)) {
            example = JsonCompat.parseJSON(JsonCompat.toString(example));
        }
        AaiSchemaFactory.resolveAll(example, schema);
        schema.title = "Root Type for " + name;
        schema.description = "The root of the " + name + " type's schema.";
        return schema;
    }

    private static void resolveType(Object thing, AaiSchema schema) {
        if (JsonCompat.isNumber(thing)) {
            boolean isInteger;
            Number value = JsonCompat.toNumber(thing);
            boolean bl = isInteger = ("" + value).indexOf(".") == -1;
            if (isInteger) {
                schema.type = "integer";
                if (value.intValue() >= -2147483647 && value.intValue() <= Integer.MAX_VALUE) {
                    schema.format = "int32";
                } else if (value.longValue() >= -9223372036854775807L && value.longValue() <= Long.MAX_VALUE) {
                    schema.format = "int64";
                }
            } else {
                schema.type = "number";
                schema.format = "double";
            }
        } else if (JsonCompat.isBoolean(thing)) {
            schema.type = "boolean";
        } else if (JsonCompat.isArray(thing)) {
            schema.type = "array";
        } else if (JsonCompat.isObject(thing)) {
            schema.type = "object";
        } else if (JsonCompat.isString(thing)) {
            String value = JsonCompat.toString(thing);
            schema.type = "string";
            if (RegexCompat.matches(value, "^(\\d{4})\\D?(0[1-9]|1[0-2])\\D?([12]\\d|0[1-9]|3[01])$")) {
                schema.format = "date";
            } else if (RegexCompat.matches(value, "^(\\d{4})\\D?(0[1-9]|1[0-2])\\D?([12]\\d|0[1-9]|3[01])(\\D?([01]\\d|2[0-3])\\D?([0-5]\\d)\\D?([0-5]\\d)?\\D?(\\d{3})?([zZ]|([\\+-])([01]\\d|2[0-3])\\D?([0-5]\\d)?)?)?$")) {
                schema.format = "date-time";
            }
        } else if (JsonCompat.isNull(thing)) {
            schema.type = "string";
        }
    }

    private static void resolveAll(Object object, AaiSchema schema) {
        AaiSchemaFactory.resolveType(object, schema);
        if (NodeCompat.equals(schema.type, "array")) {
            schema.items = schema.createItemsSchema();
            List<Object> list = JsonCompat.toList(object);
            if (list.size() > 0) {
                AaiSchemaFactory.resolveAll(list.get(0), (AaiSchema)schema.items);
            }
        } else if (NodeCompat.equals(schema.type, "object")) {
            schema.type = "object";
            List<String> keys = JsonCompat.keys(object);
            for (String propName : keys) {
                AaiSchema pschema = (AaiSchema)schema.createPropertySchema(propName);
                schema.addProperty(propName, pschema);
                Object propValue = JsonCompat.getProperty(object, propName);
                AaiSchemaFactory.resolveAll(propValue, pschema);
            }
        }
    }
}

