/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.ArrayList;
import java.util.List;

public class OasSecurityRequirementScopesMustBeEmptyRule
extends OasInvalidPropertyValueRule {
    public OasSecurityRequirementScopesMustBeEmptyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private SecurityScheme findSecurityScheme(OasDocument document, String schemeName) {
        if (document.is2xDocument()) {
            Oas20Document doc20 = (Oas20Document)document;
            if (this.hasValue(doc20.securityDefinitions)) {
                return doc20.securityDefinitions.getSecurityScheme(schemeName);
            }
        } else {
            Oas30Document doc30 = (Oas30Document)document;
            if (this.hasValue(doc30.components)) {
                return doc30.components.getSecurityScheme(schemeName);
            }
        }
        return null;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        allowedTypes.add("oauth2");
        String options = "\"oauth2\"";
        if (node.ownerDocument().getDocumentType() == DocumentType.openapi3) {
            allowedTypes.add("openIdConnect");
            options = "\"oauth2\" or \"openIdConnect\"";
        }
        List<String> snames = node.getSecurityRequirementNames();
        for (String sname : snames) {
            SecurityScheme scheme = this.findSecurityScheme((OasDocument)node.ownerDocument(), sname);
            if (!this.hasValue(scheme) || allowedTypes.indexOf(scheme.type) != -1) continue;
            List<String> scopes = node.getScopes(sname);
            this.reportIfInvalid(this.hasValue(scopes) && scopes.size() == 0, node, null, this.map("sname", sname, "options", options));
        }
    }
}

