/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.visitors;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.IVisitable;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.List;

public class CompositeVisitor
implements IVisitor {
    private List<IVisitor> visitors = new ArrayList<IVisitor>();

    public CompositeVisitor(List<IVisitor> visitors) {
        this.visitors = visitors;
    }

    public void addVisitor(IVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void addVisitors(List<? extends IVisitor> visitors) {
        this.visitors.addAll(visitors);
    }

    protected void acceptAll(IVisitable node) {
        this.visitors.forEach(visitor -> node.accept((IVisitor)visitor));
    }

    @Override
    public void visitValidationProblem(ValidationProblem problem) {
        this.acceptAll(problem);
    }

    @Override
    public void visitDocument(Document node) {
        this.acceptAll(node);
    }

    @Override
    public void visitExtension(Extension node) {
        this.acceptAll(node);
    }

    @Override
    public void visitInfo(Info node) {
        this.acceptAll(node);
    }

    @Override
    public void visitContact(Contact node) {
        this.acceptAll(node);
    }

    @Override
    public void visitLicense(License node) {
        this.acceptAll(node);
    }

    @Override
    public void visitTag(Tag node) {
        this.acceptAll(node);
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        this.acceptAll(node);
    }

    @Override
    public void visitExternalDocumentation(ExternalDocumentation node) {
        this.acceptAll(node);
    }

    @Override
    public void visitSchema(Schema node) {
        this.acceptAll(node);
    }

    @Override
    public void visitParameter(Parameter node) {
        this.acceptAll(node);
    }

    @Override
    public void visitOperation(Operation node) {
        this.acceptAll(node);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        this.acceptAll(node);
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.acceptAll(node);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.acceptAll(node);
    }
}

