/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Iterator;
import java.util.Properties;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.spi.PropertiesSource;

public class DefaultPropertiesLookup
implements PropertiesLookup {
    private final PropertiesComponent component;

    public DefaultPropertiesLookup(PropertiesComponent component) {
        this.component = component;
    }

    @Override
    public String lookup(String name) {
        try {
            return this.doLookup(name);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    private String doLookup(String name) throws NoTypeConversionAvailableException {
        Object value;
        String answer = null;
        Properties local = this.component.getLocalProperties();
        if (local != null && (value = local.get(name)) != null) {
            answer = this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
        }
        if (answer == null && this.component.getOverrideProperties() != null && (value = this.component.getOverrideProperties().get(name)) != null) {
            answer = this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
        }
        if (answer == null) {
            Iterator<PropertiesSource> it2 = this.component.getSources().iterator();
            while (answer == null && it2.hasNext()) {
                answer = it2.next().getProperty(name);
            }
        }
        if (answer == null && this.component.getInitialProperties() != null && (value = this.component.getInitialProperties().get(name)) != null) {
            answer = this.component.getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, value);
        }
        return answer;
    }
}

