/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.Converter;
import org.apache.camel.util.TimeUtils;

@Converter(generateBulkLoader=true)
public final class DurationConverter {
    private DurationConverter() {
    }

    @Converter(order=1)
    public static Long toMilliSeconds(Duration source) {
        return source.toMillis();
    }

    @Converter(order=2)
    public static Duration toDuration(Long source) {
        return Duration.ofMillis(source);
    }

    @Converter(order=3)
    public static Duration toDuration(String source) {
        if (source.startsWith("P") || source.startsWith("-P") || source.startsWith("p") || source.startsWith("-p")) {
            return Duration.parse(source);
        }
        return Duration.ofMillis(TimeUtils.toMilliSeconds(source));
    }

    @Converter(order=4)
    public static String toString(Duration source) {
        return source.toString();
    }
}

