/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.TypeConverters;
import org.apache.camel.impl.converter.ArrayTypeConverter;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.impl.converter.CoreTypeConverterRegistry;
import org.apache.camel.impl.converter.FutureTypeConverter;
import org.apache.camel.impl.converter.ToStringTypeConverter;
import org.apache.camel.impl.converter.TypeConvertersLoader;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTypeConverterRegistry
extends CoreTypeConverterRegistry {
    public static final String META_INF_SERVICES_UBER_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/UberTypeConverterLoader";
    public static final String META_INF_SERVICES_TYPE_CONVERTER_LOADER = "META-INF/services/org/apache/camel/TypeConverterLoader";
    public static final String META_INF_SERVICES_FALLBACK_TYPE_CONVERTER = "META-INF/services/org/apache/camel/FallbackTypeConverter";
    private static final Logger LOG = LoggerFactory.getLogger(BaseTypeConverterRegistry.class);
    protected final List<TypeConverterLoader> typeConverterLoaders = new ArrayList<TypeConverterLoader>();
    protected CamelContext camelContext;
    protected PackageScanClassResolver resolver;
    protected Injector injector;

    public BaseTypeConverterRegistry(CamelContext camelContext, PackageScanClassResolver resolver, Injector injector) {
        this.camelContext = camelContext;
        this.injector = injector;
        this.resolver = resolver;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<TypeConverterLoader> getTypeConverterLoaders() {
        return this.typeConverterLoaders;
    }

    @Override
    public void addTypeConverters(TypeConverters typeConverters) {
        LOG.trace("Adding type converters: {}", (Object)typeConverters);
        try {
            TypeConvertersLoader loader = new TypeConvertersLoader(typeConverters);
            CamelContextAware.trySetCamelContext(loader, this.getCamelContext());
            loader.load(this);
        }
        catch (TypeConverterLoaderException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void addFallbackTypeConverter(TypeConverter typeConverter, boolean canPromote) {
        super.addFallbackTypeConverter(typeConverter, canPromote);
        CamelContextAware.trySetCamelContext(typeConverter, this.camelContext);
    }

    private void addCoreFallbackTypeConverterToList(TypeConverter typeConverter, boolean canPromote, List<CoreTypeConverterRegistry.FallbackTypeConverter> converters) {
        LOG.trace("Adding core fallback type converter: {} which can promote: {}", (Object)typeConverter, (Object)canPromote);
        converters.add(0, new CoreTypeConverterRegistry.FallbackTypeConverter(typeConverter, canPromote));
        CamelContextAware.trySetCamelContext(typeConverter, this.camelContext);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public PackageScanClassResolver getResolver() {
        return this.resolver;
    }

    public void loadCoreAndFastTypeConverters() throws Exception {
        Collection<String> names = this.findTypeConverterLoaderClasses();
        for (String name : names) {
            LOG.debug("Resolving TypeConverterLoader: {}", (Object)name);
            Class<?> clazz = null;
            for (ClassLoader classLoader : this.getResolver().getClassLoaders()) {
                try {
                    clazz = classLoader.loadClass(name);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (clazz == null) continue;
                break;
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            Object obj = this.getInjector().newInstance(clazz, false);
            CamelContextAware.trySetCamelContext(obj, this.getCamelContext());
            if (!(obj instanceof TypeConverterLoader)) continue;
            TypeConverterLoader typeConverterLoader = (TypeConverterLoader)obj;
            CamelContextAware.trySetCamelContext(typeConverterLoader, this.getCamelContext());
            LOG.debug("TypeConverterLoader: {} loading converters", (Object)name);
            typeConverterLoader.load(this);
        }
    }

    protected Collection<String> findTypeConverterLoaderClasses() throws IOException {
        LinkedHashSet<String> loaders = new LinkedHashSet<String>();
        this.findTypeConverterLoaderClasses(loaders, META_INF_SERVICES_UBER_TYPE_CONVERTER_LOADER);
        this.findTypeConverterLoaderClasses(loaders, META_INF_SERVICES_TYPE_CONVERTER_LOADER);
        return loaders;
    }

    protected void findTypeConverterLoaderClasses(Collection<String> loaders, String basePath) throws IOException {
        Collection<URL> loaderResources = this.getLoaderUrls(basePath);
        for (URL url : loaderResources) {
            String line;
            LOG.debug("Loading file {} to retrieve list of type converters, from url: {}", (Object)basePath, (Object)url);
            BufferedReader reader = IOHelper.buffered(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            do {
                if ((line = reader.readLine()) == null || line.startsWith("#") || line.isEmpty()) continue;
                loaders.add(line);
            } while (line != null);
            IOHelper.close((Closeable)reader);
        }
    }

    protected Collection<URL> getLoaderUrls(String basePath) throws IOException {
        ArrayList<URL> loaderResources = new ArrayList<URL>();
        for (ClassLoader classLoader : this.resolver.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(basePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loaderResources.add(url);
            }
        }
        return loaderResources;
    }

    protected void loadTypeConverters() throws Exception {
        for (TypeConverterLoader loader : this.getTypeConverterLoaders()) {
            CamelContextAware.trySetCamelContext(loader, this.getCamelContext());
            loader.load(this);
        }
        try {
            this.loadFallbackTypeConverters();
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> findFallbackTypeConverterClasses() throws IOException {
        LinkedHashSet<String> loaders = new LinkedHashSet<String>();
        Collection<URL> loaderResources = this.getFallbackUrls();
        for (URL url : loaderResources) {
            LOG.debug("Loading file {} to retrieve list of fallback type converters, from url: {}", (Object)META_INF_SERVICES_FALLBACK_TYPE_CONVERTER, (Object)url);
            BufferedReader reader = IOHelper.buffered(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            try {
                reader.lines().map(String::trim).filter(l -> !l.isEmpty()).filter(l -> !l.startsWith("#")).forEach(loaders::add);
            }
            finally {
                IOHelper.close((Closeable)reader, url.toString(), LOG);
            }
        }
        return loaders;
    }

    protected Collection<URL> getFallbackUrls() throws IOException {
        ArrayList<URL> loaderResources = new ArrayList<URL>();
        for (ClassLoader classLoader : this.resolver.getClassLoaders()) {
            Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES_FALLBACK_TYPE_CONVERTER);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                loaderResources.add(url);
            }
        }
        return loaderResources;
    }

    protected void loadFallbackTypeConverters() throws IOException, ClassNotFoundException {
        Collection<String> names = this.findFallbackTypeConverterClasses();
        for (String name : names) {
            LOG.debug("Resolving FallbackTypeConverter: {}", (Object)name);
            Class clazz = this.getResolver().getClassLoaders().stream().map(cl -> ObjectHelper.loadClass(name, cl)).filter(Objects::nonNull).findAny().orElseThrow(() -> new ClassNotFoundException(name));
            Object obj = this.getInjector().newInstance(clazz, false);
            if (!(obj instanceof TypeConverter)) continue;
            TypeConverter fb = (TypeConverter)obj;
            LOG.debug("Adding loaded FallbackTypeConverter: {}", (Object)name);
            this.addFallbackTypeConverter(fb, false);
        }
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.injector == null && this.camelContext != null) {
            this.injector = this.camelContext.getInjector();
        }
        if (this.resolver == null && this.camelContext != null) {
            this.resolver = this.camelContext.adapt(ExtendedCamelContext.class).getPackageScanClassResolver();
        }
        ArrayList<CoreTypeConverterRegistry.FallbackTypeConverter> fallbacks = new ArrayList<CoreTypeConverterRegistry.FallbackTypeConverter>();
        this.addCoreFallbackTypeConverterToList(new ToStringTypeConverter(), false, fallbacks);
        this.addCoreFallbackTypeConverterToList(new ArrayTypeConverter(), true, fallbacks);
        this.addCoreFallbackTypeConverterToList(new FutureTypeConverter(this), false, fallbacks);
        this.addCoreFallbackTypeConverterToList(new AsyncProcessorTypeConverter(), true, fallbacks);
        this.fallbackConverters.addAll(fallbacks);
    }
}

