/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.TypeConverterSupport;

public class StaticMethodFallbackTypeConverter
extends TypeConverterSupport {
    private final Method method;
    private final boolean useExchange;
    private final TypeConverterRegistry registry;
    private final boolean allowNull;

    public StaticMethodFallbackTypeConverter(Method method, TypeConverterRegistry registry, boolean allowNull) {
        this.method = method;
        this.useExchange = method.getParameterCount() == 4;
        this.registry = registry;
        this.allowNull = allowNull;
    }

    @Override
    public boolean allowNull() {
        return this.allowNull;
    }

    public String toString() {
        return "StaticMethodFallbackTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, null, type, exchange, value, this.registry) : ObjectHelper.invokeMethod(this.method, null, type, value, this.registry));
    }
}

