/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePackageScanResolver
extends ServiceSupport
implements CamelContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String[] acceptableSchemes = new String[0];
    private final Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private CamelContext camelContext;

    public BasePackageScanResolver() {
        this.initialize();
    }

    public void initialize() {
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.log.trace("Adding ContextClassLoader from current thread: {}", (Object)ccl);
                this.classLoaders.add(ccl);
            }
        }
        catch (Exception e) {
            this.log.warn("Cannot add ContextClassLoader from current thread due {}. This exception will be ignored.", (Object)e.getMessage());
        }
        this.classLoaders.add(BasePackageScanResolver.class.getClassLoader());
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void setAcceptableSchemes(String schemes) {
        if (schemes != null) {
            this.acceptableSchemes = schemes.split(";");
        }
    }

    protected boolean isAcceptableScheme(String urlPath) {
        if (urlPath != null) {
            for (String scheme : this.acceptableSchemes) {
                if (!urlPath.startsWith(scheme)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(new LinkedHashSet<ClassLoader>(this.classLoaders));
    }

    protected URL customResourceLocator(URL url) throws IOException {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.log.trace("Getting resource URL for package: {} with classloader: {}", (Object)packageName, (Object)loader);
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }
}

