/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.engine.DurationRoutePolicy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.PatternHelper;

public class DurationRoutePolicyFactory
implements RoutePolicyFactory {
    private String fromRouteId;
    private int maxMessages;
    private int maxSeconds;
    private DurationRoutePolicy.Action action = DurationRoutePolicy.Action.STOP_ROUTE;

    @Override
    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        DurationRoutePolicy policy = null;
        if (this.fromRouteId == null || PatternHelper.matchPattern(routeId, this.fromRouteId)) {
            policy = new DurationRoutePolicy(camelContext, routeId);
            policy.setMaxMessages(this.maxMessages);
            policy.setMaxSeconds(this.maxSeconds);
            policy.setAction(this.action);
        }
        return policy;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMaxSeconds() {
        return this.maxSeconds;
    }

    public void setMaxSeconds(int maxSeconds) {
        this.maxSeconds = maxSeconds;
    }

    public DurationRoutePolicy.Action getAction() {
        return this.action;
    }

    public void setAction(DurationRoutePolicy.Action action) {
        this.action = action;
    }
}

